/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter.ISampleQuantReader;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter.SampleQuantReader_1100;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter.SampleQuantReader_1200;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantReport;
import org.eclipse.core.runtime.IProgressMonitor;

public class SampleQuantReader
implements ISampleQuantReader {
    @Override
    public ISampleQuantReport read(File file, IProgressMonitor monitor) throws Exception {
        ISampleQuantReport sampleQuantReport = null;
        ZipFile zipFile = new ZipFile(file);
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "VERSION");
        String version = this.readString(dataInputStream);
        dataInputStream.close();
        ISampleQuantReader sampleQuantReader = null;
        if (version.equals("1.1.0.0")) {
            sampleQuantReader = new SampleQuantReader_1100();
        } else if (version.equals("1.2.0.0")) {
            sampleQuantReader = new SampleQuantReader_1200();
        }
        if (sampleQuantReader != null) {
            sampleQuantReport = sampleQuantReader.read(file, monitor);
        }
        return sampleQuantReport;
    }

    private DataInputStream getDataInputStream(ZipFile zipFile, String entryName) throws IOException {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            String name;
            ZipEntry zipEntry = zipEntries.nextElement();
            if (zipEntry.isDirectory() || !(name = zipEntry.getName()).equals(entryName)) continue;
            return new DataInputStream(new BufferedInputStream(zipFile.getInputStream(zipEntry)));
        }
        throw new IOException("There could be found no entry given with the name: " + entryName);
    }

    private String readString(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        StringBuilder builder = new StringBuilder();
        int i = 1;
        while (i <= length) {
            builder.append(String.valueOf(dataInputStream.readChar()));
            ++i;
        }
        return builder.toString();
    }
}

