/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum;

import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.IMassSpectrumIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.IMassSpectrumIdentifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.MassSpectrumIdentifierSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.MassSpectrumIdentifierSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IMassSpectrumIdentifierSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class MassSpectrumIdentifier {
    private static final Logger logger = Logger.getLogger(MassSpectrumIdentifier.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.msd.identifier.massSpectrumIdentifier";
    private static final String NO_IDENTIFIER_AVAILABLE = "There is no suitable mass spectrum identifier available";

    private MassSpectrumIdentifier() {
    }

    public static IProcessingInfo<IMassSpectra> identify(IScanMSD massSpectrum, IMassSpectrumIdentifierSettings identifierSettings, String identifierId, IProgressMonitor monitor) {
        return MassSpectrumIdentifier.identify(Collections.singletonList(massSpectrum), identifierSettings, identifierId, monitor);
    }

    public static IProcessingInfo<IMassSpectra> identify(IScanMSD massSpectrum, String identifierId, IProgressMonitor monitor) {
        return MassSpectrumIdentifier.identify(Collections.singletonList(massSpectrum), null, identifierId, monitor);
    }

    public static IProcessingInfo<IMassSpectra> identify(List<IScanMSD> massSpectra, IMassSpectrumIdentifierSettings identifierSettings, String identifierId, IProgressMonitor monitor) {
        IMassSpectrumIdentifier massSpectrumIdentifier = MassSpectrumIdentifier.getMassSpectrumIdentifier(identifierId);
        IProcessingInfo<IMassSpectra> processingInfo = massSpectrumIdentifier != null ? massSpectrumIdentifier.identify(massSpectra, identifierSettings, monitor) : MassSpectrumIdentifier.getNoIdentifierAvailableProcessingInfo();
        return processingInfo;
    }

    public static IProcessingInfo<IMassSpectra> identify(List<IScanMSD> massSpectra, String identifierId, IProgressMonitor monitor) {
        return MassSpectrumIdentifier.identify(massSpectra, null, identifierId, monitor);
    }

    public static IMassSpectrumIdentifierSupport getMassSpectrumIdentifierSupport() {
        IConfigurationElement[] extensions;
        MassSpectrumIdentifierSupport identifierSupport = new MassSpectrumIdentifierSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MassSpectrumIdentifierSupplier supplier = new MassSpectrumIdentifierSupplier();
            supplier.setId(element.getAttribute("id"));
            supplier.setDescription(element.getAttribute("description"));
            supplier.setIdentifierName(element.getAttribute("identifierName"));
            identifierSupport.add(supplier);
            ++n2;
        }
        return identifierSupport;
    }

    private static IMassSpectrumIdentifier getMassSpectrumIdentifier(String identifierId) {
        IConfigurationElement element = MassSpectrumIdentifier.getConfigurationElement(identifierId);
        IMassSpectrumIdentifier instance = null;
        if (element != null) {
            try {
                instance = (IMassSpectrumIdentifier)element.createExecutableExtension("identifier");
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String filterId) {
        IConfigurationElement[] elements;
        if ("".equals(filterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(filterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static IProcessingInfo<IMassSpectra> getNoIdentifierAvailableProcessingInfo() {
        ProcessingInfo processingInfo = new ProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "MassSpectrum Identifier", NO_IDENTIFIER_AVAILABLE);
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }
}

