/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.model.quantitation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.quantitation.AbstractQuantitationCompound;
import org.eclipse.chemclipse.model.quantitation.IQuantitationCompound;
import org.eclipse.chemclipse.model.quantitation.IQuantitationPeak;
import org.eclipse.chemclipse.model.quantitation.QuantitationSignal;
import org.eclipse.chemclipse.model.quantitation.QuantitationSupport;
import org.eclipse.chemclipse.model.quantitation.ResponseSignal;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;

public class QuantitationCompound
extends AbstractQuantitationCompound
implements IQuantitationCompound {
    private static final long serialVersionUID = 2376307650470986106L;

    public QuantitationCompound(String name, String concentrationUnit, int retentionTime) {
        super(name, concentrationUnit, retentionTime);
    }

    public void calculateSignalTablesFromPeaks() {
        List quantitationPeaks = this.getQuantitationPeaks();
        if (quantitationPeaks.size() > 0) {
            this.getQuantitationSignals().clear();
            this.getResponseSignals().clear();
            if (this.isUseTIC()) {
                this.createTablesTIC(quantitationPeaks);
            } else {
                this.createTablesXIC(quantitationPeaks);
            }
        }
    }

    private void createTablesTIC(List<IQuantitationPeak> quantitationPeaks) {
        boolean firstPeak = true;
        for (IQuantitationPeak quantitationPeak : quantitationPeaks) {
            double concentration = quantitationPeak.getConcentration();
            IPeak peak = quantitationPeak.getReferencePeak();
            QuantitationSupport integrationQuantitationSupport = new QuantitationSupport(peak);
            if (!integrationQuantitationSupport.validateTIC()) continue;
            double ion = 0.0;
            double response = integrationQuantitationSupport.getIntegrationArea(ion);
            if (firstPeak) {
                QuantitationSignal quantitationSignal = new QuantitationSignal(ion, 100.0);
                this.getQuantitationSignals().add((Object)quantitationSignal);
            }
            ResponseSignal concentrationResponseEntry = new ResponseSignal(ion, concentration, response);
            this.getResponseSignals().add((Object)concentrationResponseEntry);
            firstPeak = false;
        }
    }

    private void createTablesXIC(List<IQuantitationPeak> quantitationPeaks) {
        boolean firstPeak = true;
        for (IQuantitationPeak quantitationPeak : quantitationPeaks) {
            IPeakMSD peakMSD;
            IPeakMassSpectrum massSpectrum;
            IExtractedIonSignal extractedIonSignal;
            List<Double> selectedQuantitationIons;
            QuantitationSupport integrationQuantitationSupport;
            double concentration = quantitationPeak.getConcentration();
            IPeak peak = quantitationPeak.getReferencePeak();
            if (!(peak instanceof IPeakMSD) || !(integrationQuantitationSupport = new QuantitationSupport(peak)).validateXIC(selectedQuantitationIons = this.getSelectedQunatitationIons(extractedIonSignal = (massSpectrum = (peakMSD = (IPeakMSD)peak).getExtractedMassSpectrum()).getExtractedIonSignal()))) continue;
            for (double ion : selectedQuantitationIons) {
                float abundance = extractedIonSignal.getAbundance((int)ion);
                float totalSignalMassSpectrum = extractedIonSignal.getTotalSignal();
                float percentageIonAbundance = (float)(1.0 / (double)totalSignalMassSpectrum * (double)abundance);
                if (firstPeak) {
                    QuantitationSignal quantitationSignal = new QuantitationSignal(ion, (double)percentageIonAbundance);
                    this.getQuantitationSignals().add((Object)quantitationSignal);
                }
                double response = integrationQuantitationSupport.getIntegrationArea(ion);
                ResponseSignal concentrationResponseEntry = integrationQuantitationSupport.isTotalSignalIntegrated() ? new ResponseSignal(ion, concentration, response * (double)percentageIonAbundance) : new ResponseSignal(ion, concentration, response);
                this.getResponseSignals().add((Object)concentrationResponseEntry);
            }
            firstPeak = false;
        }
    }

    private List<Double> getSelectedQunatitationIons(IExtractedIonSignal extractedIonSignal) {
        ArrayList<Double> selectedQunatitationIons = new ArrayList<Double>();
        int startIon = extractedIonSignal.getStartIon();
        int stopIon = extractedIonSignal.getStopIon();
        int ion = startIon;
        while (ion <= stopIon) {
            float abundance = extractedIonSignal.getAbundance(ion);
            if (abundance > 0.0f) {
                selectedQunatitationIons.add(Double.valueOf(ion));
            }
            ++ion;
        }
        return selectedQunatitationIons;
    }
}

