/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.model.filter.peaks;

import java.util.Collection;
import java.util.function.BiPredicate;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.filter.IPeakFilter;
import org.eclipse.chemclipse.processing.Processor;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.filter.CRUDListener;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.eclipse.chemclipse.xxd.model.filter.peaks.WidthFilterSettings;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IPeakFilter.class, Filter.class, Processor.class})
public class WidthFilter
implements IPeakFilter<WidthFilterSettings> {
    private static BiPredicate<Integer, Integer> WIDTH_SMALLER_THAN_LIMIT_COMPARATOR = (width, widthSetting) -> width < widthSetting;
    private static BiPredicate<Integer, Integer> WIDTH_GREATER_THAN_LIMIT_COMPARATOR = (width, widthSetting) -> width > widthSetting;

    public String getName() {
        return "Width Filter";
    }

    public String getDescription() {
        return "Filter peaks by peak width";
    }

    public Class<WidthFilterSettings> getConfigClass() {
        return WidthFilterSettings.class;
    }

    public boolean acceptsIPeaks(Collection<? extends IPeak> items) {
        return true;
    }

    public <X extends IPeak> void filterIPeaks(CRUDListener<X, IPeakModel> listener, WidthFilterSettings configuration, MessageConsumer messageConsumer, IProgressMonitor monitor) throws IllegalArgumentException {
        Collection read = listener.read();
        if (configuration == null) {
            configuration = (WidthFilterSettings)this.createConfiguration(read);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)read.size());
        WidthPredicate<?> predicate = WidthFilter.getPredicate(configuration);
        for (IPeak peak : read) {
            WidthFilter.processPeak(configuration, listener, peak, predicate);
            subMonitor.worked(1);
        }
    }

    private static WidthPredicate<?> getPredicate(WidthFilterSettings configuration) {
        switch (configuration.getFilterSelectionCriterion()) {
            case WIDTH_SMALLER_THAN_LIMIT: {
                return new WidthPredicate<Integer>(WIDTH_SMALLER_THAN_LIMIT_COMPARATOR, (int)(configuration.getWidthValue() * 60000.0));
            }
            case WIDTH_GREATER_THAN_LIMIT: {
                return new WidthPredicate<Integer>(WIDTH_GREATER_THAN_LIMIT_COMPARATOR, (int)(configuration.getWidthValue() * 60000.0));
            }
        }
        throw new IllegalArgumentException("Unsupported Peak Filter Selection Criterion!");
    }

    private static <X extends IPeak> void processPeak(WidthFilterSettings configuration, CRUDListener<X, IPeakModel> listener, X peak, WidthPredicate<?> predicate) {
        int width = peak.getPeakModel().getWidthByInflectionPoints();
        switch (configuration.getFilterTreatmentOption()) {
            case ENABLE_PEAK: {
                if (!predicate.test(width)) break;
                peak.setActiveForAnalysis(true);
                listener.updated(peak);
                break;
            }
            case DEACTIVATE_PEAK: {
                if (!predicate.test(width)) break;
                peak.setActiveForAnalysis(false);
                listener.updated(peak);
                break;
            }
            case KEEP_PEAK: {
                if (!predicate.negate().test(width)) break;
                listener.delete(peak);
                break;
            }
            case DELETE_PEAK: {
                if (!predicate.test(width)) break;
                listener.delete(peak);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Peak Filter Treatment Option!");
            }
        }
    }

    private static class WidthPredicate<T> {
        private final BiPredicate<Integer, T> predicate;
        private final T widthSetting;

        public WidthPredicate(BiPredicate<Integer, T> predicate, T widthSetting) {
            this.predicate = predicate;
            this.widthSetting = widthSetting;
        }

        public WidthPredicate<?> negate() {
            return new WidthPredicate<T>(this.predicate.negate(), this.widthSetting);
        }

        public boolean test(int width) {
            boolean result = this.predicate.test(width, (Integer)this.widthSetting);
            return result;
        }
    }
}

