/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.model.filter.peaks;

import java.util.Collection;
import org.eclipse.chemclipse.model.core.IChromatogramPeak;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.filter.IPeakFilter;
import org.eclipse.chemclipse.processing.Processor;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.filter.CRUDListener;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.eclipse.chemclipse.xxd.model.filter.peaks.SignalToNoisePeakFilterConfig;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IPeakFilter.class, Filter.class, Processor.class})
public class SignalToNoisePeakFilter
implements IPeakFilter<SignalToNoisePeakFilterConfig> {
    public String getName() {
        return "Signal to Noise";
    }

    public Class<SignalToNoisePeakFilterConfig> getConfigClass() {
        return SignalToNoisePeakFilterConfig.class;
    }

    public <X extends IPeak> void filterIPeaks(CRUDListener<X, IPeakModel> listener, SignalToNoisePeakFilterConfig configuration, MessageConsumer messageConsumer, IProgressMonitor monitor) throws IllegalArgumentException {
        if (configuration == null) {
            configuration = new SignalToNoisePeakFilterConfig();
        }
        float maxSignalToNoise = configuration.getMaxSignalToNoise();
        float minSignalToNoise = configuration.getMinSignalToNoise();
        for (IPeak peak : listener.read()) {
            float sn;
            if (!(peak instanceof IChromatogramPeak) || !Float.isFinite(sn = ((IChromatogramPeak)peak).getSignalToNoiseRatio()) || !(Float.isFinite(maxSignalToNoise) && maxSignalToNoise > 0.0f && sn > maxSignalToNoise) && (!Float.isFinite(minSignalToNoise) || !(minSignalToNoise > 0.0f) || !(sn < minSignalToNoise))) continue;
            listener.delete((Object)peak);
        }
    }

    public boolean acceptsIPeaks(Collection<? extends IPeak> items) {
        for (IPeak iPeak : items) {
            if (iPeak instanceof IChromatogramPeak) continue;
            return false;
        }
        return true;
    }
}

