/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.model.filter.peaks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import org.eclipse.chemclipse.support.settings.DoubleSettingsProperty;
import org.eclipse.chemclipse.support.settings.EnumSelectionSettingProperty;
import org.eclipse.chemclipse.xxd.model.support.ShapeSelection;
import org.eclipse.chemclipse.xxd.model.support.TreatmentOption;

public class ShapeFilterSettings {
    @JsonProperty(value="Leading:", defaultValue="0.9")
    @JsonPropertyDescription(value="The leading value of a peak to be filtered accordingly.")
    @DoubleSettingsProperty(minValue=0.0, maxValue=100.0)
    private double leadingValue = 0.9;
    @JsonProperty(value="Tailing:", defaultValue="0.9")
    @JsonPropertyDescription(value="The tailing value of a peak to be filtered accordingly.")
    @DoubleSettingsProperty(minValue=0.0, maxValue=100.0)
    private double tailingValue = 0.9;
    @JsonProperty(value="Peak Treatment Option:")
    @EnumSelectionSettingProperty
    private TreatmentOption filterTreatmentOption = TreatmentOption.DEACTIVATE_PEAK;
    @JsonProperty(value="Peak Selection Criterion:")
    @EnumSelectionSettingProperty
    private ShapeSelection filterSelectionCriterion = ShapeSelection.TAILING_GREATER_THAN_LIMIT;

    public double getLeadingValue() {
        return this.leadingValue;
    }

    public void setLeadingValue(double leadingValue) {
        this.leadingValue = leadingValue;
    }

    public double getTailingValue() {
        return this.tailingValue;
    }

    public void setTailingValue(double tailingValue) {
        this.tailingValue = tailingValue;
    }

    public TreatmentOption getFilterTreatmentOption() {
        return this.filterTreatmentOption;
    }

    public void setFilterTreatmentOption(TreatmentOption filterTreatmentOption) {
        this.filterTreatmentOption = filterTreatmentOption;
    }

    public ShapeSelection getFilterSelectionCriterion() {
        return this.filterSelectionCriterion;
    }

    public void setFilterSelectionCriterion(ShapeSelection filterSelectionCriterion) {
        this.filterSelectionCriterion = filterSelectionCriterion;
    }
}

