/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.nmr.converter.core;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.converter.core.Converter;
import org.eclipse.chemclipse.converter.core.IMagicNumberMatcher;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.scan.IScanConverterSupport;
import org.eclipse.chemclipse.converter.scan.ScanConverterSupport;
import org.eclipse.chemclipse.converter.scan.ScanSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IComplexSignalMeasurement;
import org.eclipse.chemclipse.model.core.IMeasurement;
import org.eclipse.chemclipse.nmr.converter.core.IScanExportConverter;
import org.eclipse.chemclipse.nmr.converter.core.IScanImportConverter;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;

public class ScanConverterNMR {
    private static final Logger logger = Logger.getLogger(ScanConverterNMR.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.nmr.converter.scanSupplier";

    private ScanConverterNMR() {
    }

    public static IProcessingInfo<IMeasurement> convert(File file, String converterId, IProgressMonitor monitor) {
        IScanImportConverter importConverter = ScanConverterNMR.getScanImportConverter(converterId);
        IProcessingInfo processingInfo = importConverter != null ? importConverter.convert(file, monitor) : ScanConverterNMR.getProcessingError(file);
        return processingInfo;
    }

    public static IProcessingInfo<Collection<IComplexSignalMeasurement<?>>> convert(File file, IProgressMonitor monitor) {
        IProcessingInfo error = ScanConverterNMR.getProcessingError(file);
        IScanConverterSupport converterSupport = ScanConverterNMR.getScanConverterSupport();
        try {
            List availableConverterIds = converterSupport.getAvailableConverterIds(file);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)availableConverterIds.size());
            for (String converterId : availableConverterIds) {
                IProcessingInfo processingInfo;
                IScanImportConverter importConverter = ScanConverterNMR.getScanImportConverter(converterId);
                if (importConverter == null || (processingInfo = importConverter.convert(file, (IProgressMonitor)subMonitor.split(1))) == null) continue;
                if (processingInfo.hasErrorMessages()) {
                    error.addMessages(processingInfo);
                    continue;
                }
                Object object = processingInfo.getProcessingResult();
                if (object instanceof IComplexSignalMeasurement) {
                    IComplexSignalMeasurement measurement = (IComplexSignalMeasurement)object;
                    ProcessingInfo info = new ProcessingInfo();
                    info.setProcessingResult(Collections.singleton(measurement));
                    info.addMessages(processingInfo);
                    return info;
                }
                if (!(object instanceof Collection)) continue;
                Collection collection = (Collection)object;
                ProcessingInfo info = new ProcessingInfo();
                info.setProcessingResult((Object)collection);
                info.addMessages(processingInfo);
                return info;
            }
        }
        catch (NoConverterAvailableException noConverterAvailableException) {
            // empty catch block
        }
        return error;
    }

    public static IProcessingInfo<?> export(File file, IComplexSignalMeasurement<?> measurement, String converterId, IProgressMonitor monitor) {
        try {
            IScanExportConverter exportConverter = ScanConverterNMR.getScanExportConverter(converterId);
            if (exportConverter != null) {
                ProcessingInfo result = new ProcessingInfo();
                exportConverter.convert(file, measurement, (MessageConsumer)result, monitor);
                return result;
            }
            return ScanConverterNMR.getProcessingError(file);
        }
        catch (Exception e) {
            ProcessingInfo processingInfo = new ProcessingInfo();
            processingInfo.addErrorMessage(converterId, "Failed to export", (Throwable)e);
            return processingInfo;
        }
    }

    private static <T> IScanImportConverter<T> getScanImportConverter(String converterId) {
        IConfigurationElement element = ScanConverterNMR.getConfigurationElement(converterId);
        IScanImportConverter instance = null;
        if (element != null) {
            try {
                instance = (IScanImportConverter)element.createExecutableExtension("importConverter");
            }
            catch (CoreException e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return instance;
    }

    private static IScanExportConverter getScanExportConverter(String converterId) throws CoreException {
        IConfigurationElement element = ScanConverterNMR.getConfigurationElement(converterId);
        if (element != null) {
            return (IScanExportConverter)element.createExecutableExtension("exportConverter");
        }
        return null;
    }

    private static IConfigurationElement getConfigurationElement(String converterId) {
        IConfigurationElement[] elements;
        if ("".equals(converterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(converterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public static IScanConverterSupport getScanConverterSupport() {
        IConfigurationElement[] extensions;
        ScanConverterSupport converterSupport = new ScanConverterSupport(DataCategory.NMR);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ScanSupplier supplier = new ScanSupplier();
            supplier.setFileExtension(element.getAttribute("fileExtension"));
            supplier.setFileName(element.getAttribute("fileName"));
            supplier.setDirectoryExtension(element.getAttribute("directoryExtension"));
            if (Converter.isValid((String)supplier.getFileExtension()) && Converter.isValid((String)supplier.getFileName()) && Converter.isValid((String)supplier.getDirectoryExtension())) {
                supplier.setId(element.getAttribute("id"));
                supplier.setDescription(element.getAttribute("description"));
                supplier.setFilterName(element.getAttribute("filterName"));
                supplier.setExportable(Boolean.valueOf(element.getAttribute("isExportable")).booleanValue());
                supplier.setImportable(Boolean.valueOf(element.getAttribute("isImportable")).booleanValue());
                supplier.setMagicNumberMatcher(ScanConverterNMR.getMagicNumberMatcher(element));
                converterSupport.add((ISupplier)supplier);
            }
            ++n2;
        }
        return converterSupport;
    }

    private static IMagicNumberMatcher getMagicNumberMatcher(IConfigurationElement element) {
        IMagicNumberMatcher magicNumberMatcher;
        try {
            magicNumberMatcher = (IMagicNumberMatcher)element.createExecutableExtension("importMagicNumberMatcher");
        }
        catch (Exception e) {
            magicNumberMatcher = null;
        }
        return magicNumberMatcher;
    }

    private static <T> IProcessingInfo<T> getProcessingError(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addErrorMessage("Scan Converter", "No suitable converter was found for: " + file);
        return processingInfo;
    }
}

