/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.runtime;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.runtime.AmdisSupport;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.runtime.IAmdisSupport;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.runtime.IExtendedRuntimeSupport;
import org.eclipse.chemclipse.support.runtime.AbstractWindowsSupport;

public class WindowsSupport
extends AbstractWindowsSupport
implements IExtendedRuntimeSupport {
    private IAmdisSupport amdisSupport = new AmdisSupport(this);

    public WindowsSupport(String application, String parameter) throws FileNotFoundException {
        super(application, parameter);
    }

    public boolean isValidApplicationExecutable() {
        return this.amdisSupport.validateExecutable();
    }

    @Override
    public IAmdisSupport getAmdisSupport() {
        return this.amdisSupport;
    }

    public Process executeOpenCommand() throws IOException {
        Runtime runtime = Runtime.getRuntime();
        return runtime.exec(this.getOpenCommand());
    }

    public Process executeKillCommand() throws IOException {
        Runtime runtime = Runtime.getRuntime();
        return runtime.exec(this.getKillCommand());
    }

    private String getOpenCommand() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getApplication().replace("AMDIS32$.exe", "AMDIS_32.exe"));
        return builder.toString();
    }

    private String getKillCommand() {
        String command = "";
        if (this.isValidApplicationExecutable()) {
            command = "taskkill /f /IM AMDIS_32.exe";
        }
        return command;
    }
}

