/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.internal.identifier;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.msd.converter.peak.PeakConverterMSD;
import org.eclipse.chemclipse.processing.core.DefaultProcessingResult;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.IProcessingResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class AMDISParser {
    private static final int WAIT_TIMEOUT_ELU = Integer.parseInt(System.getProperty("chemclipse.amdis.timeout.elu", "60"));
    private static final int WAIT_TIMEOUT_COMPLETE = Integer.parseInt(System.getProperty("chemclipse.amdis.timeout.complete", "5"));
    private static final int WATCH_WINDOW = Integer.parseInt(System.getProperty("chemclipse.amdis.watch.window", "1"));
    private static final int WAIT_MS = 100;
    private static final int CHECK_WINDOW_SIZE = (int)(TimeUnit.SECONDS.toMillis(WATCH_WINDOW) / 100L);
    private final File eluFile;
    private final File finFile;
    private final File resFile;

    public AMDISParser(File fileChromatogram) {
        this.eluFile = this.getFile(fileChromatogram, "ELU");
        this.finFile = this.getFile(fileChromatogram, "FIN");
        this.resFile = this.getFile(fileChromatogram, "RES");
    }

    public IProcessingResult<IPeaks> parse(IProgressMonitor monitor) throws InterruptedException {
        DefaultProcessingResult result = new DefaultProcessingResult();
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (!this.waitForFile(this.eluFile, WAIT_TIMEOUT_ELU, TimeUnit.SECONDS, (IProgressMonitor)subMonitor.split(10, 0))) {
                throw new InterruptedException("AMDIS does not created required file within the time bounds");
            }
            if (!this.waitForFileComplete(this.eluFile, WAIT_TIMEOUT_COMPLETE, TimeUnit.MINUTES, (IProgressMonitor)subMonitor.split(10, 0))) {
                throw new InterruptedException("AMDIS does not finished writing file within the time bounds");
            }
            IProcessingInfo peaksResult = PeakConverterMSD.convert((File)this.eluFile, (String)"org.eclipse.chemclipse.msd.converter.supplier.amdis.peak.elu", (IProgressMonitor)subMonitor.split(70));
            if (peaksResult == null) {
                result.addErrorMessage("AMDIS Identifier", "PeakParser returned no result");
                DefaultProcessingResult defaultProcessingResult = result;
                return defaultProcessingResult;
            }
            try {
                Object processingResult = peaksResult.getProcessingResult();
                if (processingResult instanceof IPeaks) {
                    result.setProcessingResult((Object)((IPeaks)peaksResult.getProcessingResult()));
                }
                for (IProcessingMessage message : peaksResult.getMessages()) {
                    result.addMessage(message);
                }
            }
            catch (IOException e) {
                result.addErrorMessage("AMDIS Identifier", "Reading data failed: " + e);
            }
        }
        finally {
            this.eluFile.delete();
            this.finFile.delete();
            this.resFile.delete();
        }
        return result;
    }

    private boolean waitForFileComplete(File file, long timeout, TimeUnit unit, IProgressMonitor monitor) throws IOException, InterruptedException {
        long millis = unit.toMillis(timeout);
        long start = System.currentTimeMillis();
        long[] size = new long[CHECK_WINDOW_SIZE];
        int index = 0;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Wait for file " + file.getName() + " to complete"), (int)((int)(millis / 100L)));
        while (millis > System.currentTimeMillis() - start) {
            Thread.sleep(100L);
            subMonitor.worked(1);
            if (index < CHECK_WINDOW_SIZE) {
                long length = file.length();
                if (length <= 0L) continue;
                size[index] = length;
                ++index;
                continue;
            }
            if (this.fileSizeHasChanged(size)) {
                index = 0;
                continue;
            }
            return true;
        }
        return false;
    }

    private boolean fileSizeHasChanged(long[] size) {
        long compare = size[0];
        int i = 1;
        while (i < size.length) {
            if (compare != size[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean waitForFile(File file, long timeout, TimeUnit unit, IProgressMonitor monitor) throws IOException, InterruptedException {
        long start = System.currentTimeMillis();
        long millis = unit.toMillis(timeout);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Wait for file " + file.getName() + " to appear"), (int)((int)(millis / 100L)));
        while (millis > System.currentTimeMillis() - start && !file.exists()) {
            Thread.sleep(100L);
            subMonitor.worked(1);
        }
        return file.exists();
    }

    private File getFile(File fileChromatogram, String ext) {
        File file = new File(String.valueOf(fileChromatogram.getParent()) + File.separator + fileChromatogram.getName().replace(".CDF", "." + ext).toUpperCase());
        if (file.exists()) {
            file.delete();
        }
        file.deleteOnExit();
        return file;
    }
}

