/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.swt;

import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.chemclipse.ux.extension.ui.Activator;
import org.eclipse.chemclipse.ux.extension.ui.definitions.TileDefinition;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TaskTile
extends Composite {
    public static final int LARGE_TITLE = 2;
    public static final int HIGHLIGHT = 4;
    public static final int WRAP_IMAGE = 8;
    private Color colorInactive;
    private Color colorActive;
    private Label labelImage;
    private Label textSection;
    private Label textDesciption;
    private final Cursor handCursor;
    private final Cursor waitCursor;
    private final TileDefinition definition;
    private final Consumer<TileDefinition> definitionConsumer;
    private final Color[] colors;
    private final Function<TileDefinition, Integer> styleFunction;

    TaskTile(Composite parent, TileDefinition definition, Consumer<TileDefinition> definitionConsumer, Function<TileDefinition, Integer> styleFunction, Color[] colors) {
        super(parent, 0);
        if (colors.length < 3) {
            throw new IllegalArgumentException("must suplly three colors");
        }
        this.definition = definition;
        this.definitionConsumer = definitionConsumer;
        this.styleFunction = styleFunction;
        this.colors = colors;
        this.initialize();
        this.waitCursor = new Cursor((Device)parent.getDisplay(), 1);
        this.handCursor = new Cursor((Device)parent.getDisplay(), 21);
        this.updateFromDefinition();
    }

    public void dispose() {
        super.dispose();
        this.handCursor.dispose();
        this.waitCursor.dispose();
    }

    public TileDefinition getDefinition() {
        return this.definition;
    }

    private void setContent(Image image, String section, String description, boolean wrapImage) {
        this.labelImage.setImage(image);
        if (image == null) {
            this.modifyLabelImage(true, wrapImage);
        } else {
            this.modifyLabelImage(false, wrapImage);
        }
        this.textSection.setText(section);
        this.textDesciption.setText(description == null ? "" : description);
    }

    public void setActive() {
        this.setBackgroundColor(this.colorActive);
    }

    public void setInactive() {
        this.setBackgroundColor(this.colorInactive);
    }

    private void initialize() {
        this.setLayout((Layout)new GridLayout(1, true));
        Composite composite = new Composite((Composite)this, 0);
        composite.setBackgroundMode(2);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        composite.setLayout((Layout)new GridLayout(2, true));
        this.addControlListener((Control)composite);
        this.addControlListener((Control)this);
        this.labelImage = this.addLabelImage(composite);
        this.textSection = this.addTextSection(composite);
        this.textDesciption = this.addTextDescription(composite);
    }

    private Label addLabelImage(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)this.getGridData(0x1000008, 0x1000008, 1));
        this.addControlListener((Control)label);
        return label;
    }

    private Label addTextSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("");
        label.setLayoutData((Object)this.getGridData(1, 0x1000008, 1));
        label.setForeground(this.colors[2]);
        this.addControlListener((Control)label);
        return label;
    }

    private Label addTextDescription(Composite parent) {
        Label label = new Label(parent, 0x1000040);
        label.setText("");
        label.setLayoutData((Object)this.getGridData(0x1000000, 1, 2));
        this.addControlListener((Control)label);
        return label;
    }

    private GridData getGridData(int horizontalAlignment, int verticalAlignment, int horizontalSpan) {
        GridData gridData = new GridData(1808);
        gridData.horizontalAlignment = horizontalAlignment;
        gridData.verticalAlignment = verticalAlignment;
        gridData.horizontalSpan = horizontalSpan;
        gridData.grabExcessHorizontalSpace = true;
        return gridData;
    }

    private void setBackgroundColor(Color color) {
        this.setBackground(color);
        this.labelImage.setBackground(color);
        this.textSection.setBackground(color);
        this.textDesciption.setBackground(color);
    }

    private void modifyLabelImage(boolean exclude, boolean wrap) {
        GridData gridDataLabel = (GridData)this.labelImage.getLayoutData();
        gridDataLabel.exclude = exclude;
        gridDataLabel.horizontalSpan = wrap ? 2 : 1;
        gridDataLabel.horizontalAlignment = wrap ? 0x1000000 : 0x1000008;
        gridDataLabel.grabExcessVerticalSpace = !wrap;
        this.labelImage.setVisible(!exclude);
        GridData gridDataText = (GridData)this.textSection.getLayoutData();
        gridDataText.horizontalAlignment = exclude || wrap ? 0x1000000 : 1;
        gridDataText.horizontalSpan = exclude || wrap ? 2 : 1;
    }

    private void addControlListener(final Control control) {
        control.addMouseListener((MouseListener)new MouseAdapter(){
            private boolean active;

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    this.active = true;
                }
            }

            public void mouseUp(MouseEvent e) {
                if (this.active && this.matches(e)) {
                    TaskTile.this.handleSelection();
                }
            }

            private boolean matches(MouseEvent e) {
                Point size = control.getSize();
                return e.x >= 0 && e.x <= size.x && e.y >= 0 && e.y <= size.y;
            }
        });
        control.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    TaskTile.this.handleSelection();
                }
            }
        });
    }

    private void handleSelection() {
        Cursor oldCursor = this.getCursor();
        try {
            this.setCursor(this.waitCursor);
            if (this.definition != null) {
                try {
                    this.definitionConsumer.accept(this.definition);
                }
                catch (RuntimeException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "TaskTile", "invoke of consumer failed", (Throwable)e));
                }
            }
        }
        finally {
            this.setCursor(oldCursor);
        }
    }

    private void updateStyle(int style) {
        if ((style & 4) != 0) {
            this.setCursor(this.handCursor);
            this.colorActive = this.colors[0];
            this.colorInactive = this.colors[1];
            this.labelImage.setEnabled(true);
            this.textSection.setEnabled(true);
            this.textDesciption.setEnabled(true);
        } else {
            this.setCursor(null);
            this.colorActive = this.colors[1];
            this.colorInactive = this.colors[1];
            this.labelImage.setEnabled(false);
            this.textSection.setEnabled(false);
            this.textDesciption.setEnabled(false);
        }
        int fontSize = (style & 2) != 0 ? 40 : 18;
        Font font = new Font((Device)this.getDisplay(), "Arial", fontSize, 1);
        this.textSection.setFont(font);
        font.dispose();
    }

    public void updateFromDefinition() {
        if (this.definition != null) {
            Integer style = this.styleFunction.apply(this.definition);
            this.updateStyle(style != null ? style : 0);
            this.setContent(this.definition.getIcon(), this.definition.getTitle(), this.definition.getDescription(), (style & 8) != 0);
            this.setInactive();
            this.layout(true);
            this.redraw();
        }
    }
}

