/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.definitions;

import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ScanType
implements EventHandler {
    public static final String SCAN_TYPE = "org.eclipse.chemclipse.ux.extension.ui.definitions.scanType";
    public static final String SCAN_SELECTION = "org.eclipse.chemclipse.ux.extension.ui.scanSelection";
    public static final String SCAN_TYPE_MSD = "SCAN_TYPE_MSD";
    public static final String SCAN_TYPE_CSD = "SCAN_TYPE_CSD";
    public static final String SCAN_TYPE_WSD = "SCAN_TYPE_WSD";
    public static final String SCAN_TYPE_XXD = "SCAN_TYPE_XXD";
    public static final String SCAN_TYPE_NONE = "SCAN_TYPE_NONE";

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        Object property = event.getProperty("org.eclipse.e4.data");
        IScanMSD scanSelection = null;
        String scanType = SCAN_TYPE_NONE;
        if (topic.equals("scan/msd/update/selection")) {
            scanSelection = (IScanMSD)property;
            scanType = SCAN_TYPE_MSD;
        } else if (topic.equals("scan/csd/update/selection")) {
            scanSelection = (IScanCSD)property;
            scanType = SCAN_TYPE_CSD;
        } else if (topic.equals("scan/wsd/update/selection")) {
            scanSelection = (IScanWSD)property;
            scanType = SCAN_TYPE_WSD;
        } else if (topic.equals("scan/xxd/unload/selection")) {
            scanSelection = null;
            scanType = SCAN_TYPE_NONE;
        }
        IEclipseContext eclipseContext = ModelSupportAddon.getEclipseContext();
        if (eclipseContext != null) {
            eclipseContext.set(SCAN_SELECTION, (Object)scanSelection);
            eclipseContext.set(SCAN_TYPE, (Object)scanType);
        }
    }

    public static IScan getSelectedScan() {
        IEclipseContext eclipseContext = ModelSupportAddon.getEclipseContext();
        Object object = eclipseContext.get(SCAN_SELECTION);
        IScan scan = null;
        if (object != null && object instanceof IScan) {
            scan = (IScan)object;
        }
        return scan;
    }

    public static IScanMSD getSelectedScanMSD() {
        IEclipseContext eclipseContext = ModelSupportAddon.getEclipseContext();
        Object object = eclipseContext.get(SCAN_SELECTION);
        IScanMSD scanMSD = null;
        if (object != null && object instanceof IScanMSD) {
            scanMSD = (IScanMSD)object;
        }
        return scanMSD;
    }

    public static IScanCSD getSelectedScanCSD() {
        IEclipseContext eclipseContext = ModelSupportAddon.getEclipseContext();
        Object object = eclipseContext.get(SCAN_SELECTION);
        IScanCSD scanCSD = null;
        if (object != null && object instanceof IScanCSD) {
            scanCSD = (IScanCSD)object;
        }
        return scanCSD;
    }

    public static IScanWSD getSelectedScanWSD() {
        IEclipseContext eclipseContext = ModelSupportAddon.getEclipseContext();
        Object object = eclipseContext.get(SCAN_SELECTION);
        IScanWSD scanWSD = null;
        if (object != null && object instanceof IScanWSD) {
            scanWSD = (IScanWSD)object;
        }
        return scanWSD;
    }
}

