/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.core.internal.support;

import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.core.internal.support.AbstractRetentionTimeModifier;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.exceptions.FilterException;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.settings.FilterSettingsStretch;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;

public class RetentionTimeStretcher
extends AbstractRetentionTimeModifier {
    private RetentionTimeStretcher() {
    }

    public static void stretchChromatogram(IChromatogramSelection chromatogramSelection, FilterSettingsStretch filterSettings) throws FilterException {
        if (chromatogramSelection == null || chromatogramSelection.getChromatogram() == null) {
            throw new FilterException("The chromatogram must not be null.");
        }
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        int scanRange = chromatogram.getNumberOfScans() - 1;
        if (scanRange > 0) {
            float retentionTimeRange = filterSettings.getChromatogramLength() - filterSettings.getScanDelay();
            int scanInterval = Math.round(retentionTimeRange / (float)scanRange);
            chromatogram.setScanDelay(filterSettings.getScanDelay());
            chromatogram.setScanInterval(scanInterval);
            chromatogram.recalculateRetentionTimes();
        }
        RetentionTimeStretcher.adjustScanDelayAndRetentionTimeRange(chromatogramSelection);
    }
}

