/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.core.internal.support;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.core.internal.support.AbstractRetentionTimeModifier;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.exceptions.FilterException;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.settings.FilterSettingsShift;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;

public class RetentionTimeShifter
extends AbstractRetentionTimeModifier {
    private RetentionTimeShifter() {
    }

    public static void shiftRetentionTimes(IChromatogramSelection chromatogramSelection, FilterSettingsShift filterSettings) throws FilterException {
        if (chromatogramSelection == null || chromatogramSelection.getChromatogram() == null) {
            throw new FilterException("The chromatogram must not be null.");
        }
        List<Integer> scansToRemove = RetentionTimeShifter.adjustRetentionTimesAndReturnScansToRemove(chromatogramSelection, filterSettings);
        RetentionTimeShifter.removeMarkedScans(chromatogramSelection, scansToRemove);
        RetentionTimeShifter.adjustScanDelayAndRetentionTimeRange(chromatogramSelection);
    }

    private static List<Integer> adjustRetentionTimesAndReturnScansToRemove(IChromatogramSelection chromatogramSelection, FilterSettingsShift filterSettings) {
        int stopScan;
        int startScan;
        boolean isShiftAllScans = filterSettings.isShiftAllScans();
        int millisecondToShift = filterSettings.getMillisecondsToShift();
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        if (isShiftAllScans) {
            startScan = 1;
            stopScan = chromatogram.getNumberOfScans();
        } else {
            startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
            stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        }
        int retentionTimeLeftBorder = RetentionTimeShifter.getRetentionTimeLeftBorder(chromatogram, startScan);
        int retentionTimeRightBorder = RetentionTimeShifter.getRetentionTimeRightBorder(chromatogram, stopScan);
        ArrayList<Integer> scansToRemove = new ArrayList<Integer>();
        int scan = startScan;
        while (scan <= stopScan) {
            IScan scanRecord = chromatogram.getScan(scan);
            int retentionTimeNew = RetentionTimeShifter.calculateNewRetentionTime(scanRecord, millisecondToShift);
            if (retentionTimeNew <= retentionTimeLeftBorder || retentionTimeNew >= retentionTimeRightBorder) {
                scansToRemove.add(scan);
            } else {
                scanRecord.setRetentionTime(retentionTimeNew);
            }
            ++scan;
        }
        return scansToRemove;
    }

    private static int getRetentionTimeLeftBorder(IChromatogram chromatogram, int startScan) {
        int retentionTime = 0;
        int scanLeftBorder = startScan - 1;
        IScan scan = chromatogram.getScan(scanLeftBorder);
        if (scan != null) {
            retentionTime = scan.getRetentionTime();
        }
        return retentionTime;
    }

    private static int getRetentionTimeRightBorder(IChromatogram chromatogram, int stopScan) {
        int retentionTime = Integer.MAX_VALUE;
        int scanRightBorder = stopScan + 1;
        IScan scan = chromatogram.getScan(scanRightBorder);
        if (scan != null) {
            retentionTime = scan.getRetentionTime();
        }
        return retentionTime;
    }

    private static IChromatogram removeMarkedScans(IChromatogramSelection chromatogramSelection, List<Integer> scansToRemove) {
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        int counter = 0;
        for (int scan : scansToRemove) {
            chromatogram.removeScan(scan - counter);
            ++counter;
        }
        return chromatogram;
    }

    private static int calculateNewRetentionTime(IScan scanRecord, int millisecondToShift) {
        int actualRetentionTime = scanRecord.getRetentionTime();
        return actualRetentionTime + millisecondToShift;
    }
}

