/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.components;

import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.swt.ui.components.ISearchListener;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SearchSupportUI
extends Composite {
    private Text text;
    private Button checkbox;
    private ISearchListener searchListener;

    public SearchSupportUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void reset() {
        this.setSearchText("");
    }

    public void setSearchListener(ISearchListener searchListener) {
        this.searchListener = searchListener;
    }

    public void setSearchText(String searchText) {
        this.text.setText(searchText);
        this.runSearch();
    }

    public String getSearchText() {
        return this.text.getText().trim();
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        composite.setLayout((Layout)gridLayout);
        this.createTextSearch(composite);
        this.createButtonSearch(composite);
        this.createButtonReset(composite);
        this.createCheckBoxCaseSensitive(composite);
    }

    private void createTextSearch(Composite parent) {
        this.text = new Text(parent, 2048);
        this.text.setText("");
        this.text.setToolTipText("Type in the search items.");
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 10 || e.keyCode == 13 || e.keyCode == 0x1000050) {
                    SearchSupportUI.this.runSearch();
                } else if (SearchSupportUI.this.text.getText().trim().equals("")) {
                    SearchSupportUI.this.runSearch();
                }
            }
        });
    }

    private void createButtonSearch(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Search");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchSupportUI.this.runSearch();
            }
        });
    }

    private void createButtonReset(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Reset");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchSupportUI.this.text.setText("");
                SearchSupportUI.this.runSearch();
            }
        });
    }

    private void createCheckBoxCaseSensitive(Composite parent) {
        this.checkbox = new Button(parent, 32);
        this.checkbox.setText("Case sensitive");
        this.checkbox.setSelection(PreferenceSupplier.isSearchCaseSensitive());
        this.checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceSupplier.setSearchCaseSensitive(SearchSupportUI.this.checkbox.getSelection());
                SearchSupportUI.this.runSearch();
            }
        });
    }

    private void runSearch() {
        if (this.searchListener != null) {
            String searchText = this.text.getText().trim();
            boolean caseSensitive = this.checkbox.getSelection();
            this.searchListener.performSearch(searchText, caseSensitive);
        }
    }
}

