/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.comparator;

import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.support.ui.swt.AbstractRecordTableComparator;
import org.eclipse.chemclipse.support.ui.swt.IRecordTableComparator;
import org.eclipse.jface.viewers.Viewer;

public class PeakTargetsTableComparator
extends AbstractRecordTableComparator
implements IRecordTableComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        int sortOrder = 0;
        if (e1 instanceof IIdentificationTarget && e2 instanceof IIdentificationTarget) {
            IIdentificationTarget identificationTarget1 = (IIdentificationTarget)e1;
            ILibraryInformation libraryInformation1 = identificationTarget1.getLibraryInformation();
            IComparisonResult comparisonResult1 = identificationTarget1.getComparisonResult();
            IIdentificationTarget identificationTarget2 = (IIdentificationTarget)e2;
            ILibraryInformation libraryInformation2 = identificationTarget2.getLibraryInformation();
            IComparisonResult comparisonResult2 = identificationTarget2.getComparisonResult();
            switch (this.getPropertyIndex()) {
                case 0: {
                    sortOrder = libraryInformation2.getName().compareTo(libraryInformation1.getName());
                    break;
                }
                case 1: {
                    sortOrder = Float.compare(comparisonResult2.getMatchFactor(), comparisonResult1.getMatchFactor());
                    break;
                }
                case 2: {
                    sortOrder = Float.compare(comparisonResult2.getReverseMatchFactor(), comparisonResult1.getReverseMatchFactor());
                    break;
                }
                case 3: {
                    sortOrder = Float.compare(comparisonResult2.getMatchFactorDirect(), comparisonResult1.getMatchFactorDirect());
                    break;
                }
                case 4: {
                    sortOrder = Float.compare(comparisonResult2.getReverseMatchFactorDirect(), comparisonResult1.getReverseMatchFactorDirect());
                    break;
                }
                default: {
                    sortOrder = 0;
                }
            }
        }
        if (this.getDirection() == 0) {
            sortOrder = -sortOrder;
        }
        return sortOrder;
    }
}

