/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.internal.filter.PeakIdentificationBatchJobEventFilter;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.io.IPeakIdentificationBatchJobReader;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakIdentificationBatchJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.PeakIdentificationBatchJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.PeakIdentificationEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.PeakInputEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.PeakIntegrationEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.PeakOutputEntry;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakIdentificationBatchJobReader
implements IPeakIdentificationBatchJobReader {
    @Override
    public IPeakIdentificationBatchJob read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        PeakIdentificationBatchJob batchJob = new PeakIdentificationBatchJob(file.getName());
        try {
            this.readHeader(file, batchJob);
            this.readPeakInputEntries(file, batchJob, monitor);
            this.readPeakIntegrationEntry(file, batchJob, monitor);
            this.readPeakIdentificationEntry(file, batchJob, monitor);
            this.readPeakOutputEntries(file, batchJob, monitor);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        return batchJob;
    }

    private void readHeader(File file, IPeakIdentificationBatchJob batchJob) throws XMLStreamException, IOException {
        XMLInputFactory.newInstance().setProperty("javax.xml.stream.isCoalescing", true);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        while (eventReader.hasNext()) {
            String elementName;
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                elementName = event.asStartElement().getName().getLocalPart();
                if (elementName.equals("ReportFolder")) {
                    this.setReportFolder(batchJob, event, eventReader);
                    continue;
                }
                if (!elementName.equals("OverrideReport")) continue;
                this.setOverrideReport(batchJob, event, eventReader);
                continue;
            }
            if (event.isEndElement() && (elementName = event.asEndElement().getName().getLocalPart()).equals("Header")) break;
        }
        eventReader.close();
        bufferedInputStream.close();
    }

    private void setReportFolder(IPeakIdentificationBatchJob batchJob, XMLEvent event, XMLEventReader eventReader) throws XMLStreamException {
        event = eventReader.nextEvent();
        batchJob.setReportFolder(event.asCharacters().getData());
    }

    private void setOverrideReport(IPeakIdentificationBatchJob batchJob, XMLEvent event, XMLEventReader eventReader) throws XMLStreamException {
        event = eventReader.nextEvent();
        batchJob.setOverrideReport(Boolean.parseBoolean(event.asCharacters().getData()));
    }

    private void readPeakInputEntries(File file, IPeakIdentificationBatchJob batchJob, IProgressMonitor monitor) throws XMLStreamException, IOException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        ArrayList<String> acceptedElements = new ArrayList<String>();
        acceptedElements.add("InputEntry");
        PeakIdentificationBatchJobEventFilter eventFilter = new PeakIdentificationBatchJobEventFilter(acceptedElements);
        XMLEventReader filteredEventReader = inputFactory.createFilteredReader(eventReader, eventFilter);
        while (filteredEventReader.hasNext()) {
            XMLEvent event = filteredEventReader.nextEvent();
            event = eventReader.nextEvent();
            PeakInputEntry inputEntry = new PeakInputEntry(event.asCharacters().getData());
            batchJob.getPeakInputEntries().add(inputEntry);
        }
        eventReader.close();
        bufferedInputStream.close();
    }

    private void readPeakIntegrationEntry(File file, IPeakIdentificationBatchJob batchJob, IProgressMonitor monitor) throws XMLStreamException, IOException {
        String processorId = "";
        boolean processReport = false;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        ArrayList<String> acceptedElements = new ArrayList<String>();
        acceptedElements.add("IntegrationEntry");
        PeakIdentificationBatchJobEventFilter eventFilter = new PeakIdentificationBatchJobEventFilter(acceptedElements);
        XMLEventReader filteredEventReader = inputFactory.createFilteredReader(eventReader, eventFilter);
        XMLEvent event = filteredEventReader.nextEvent();
        Iterator<Attribute> attributes = event.asStartElement().getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            String attributeName = attribute.getName().getLocalPart();
            if (attributeName.equals("processorId")) {
                processorId = attribute.getValue();
            }
            if (!attributeName.equals("processReport")) continue;
            processReport = Boolean.parseBoolean(attribute.getValue());
        }
        PeakIntegrationEntry peakIntegrationEntry = new PeakIntegrationEntry(processorId, processReport);
        batchJob.setPeakIntegrationEntry(peakIntegrationEntry);
        eventReader.close();
        bufferedInputStream.close();
    }

    private void readPeakIdentificationEntry(File file, IPeakIdentificationBatchJob batchJob, IProgressMonitor monitor) throws XMLStreamException, IOException {
        String processorId = "";
        boolean processReport = false;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        ArrayList<String> acceptedElements = new ArrayList<String>();
        acceptedElements.add("IdentificationEntry");
        PeakIdentificationBatchJobEventFilter eventFilter = new PeakIdentificationBatchJobEventFilter(acceptedElements);
        XMLEventReader filteredEventReader = inputFactory.createFilteredReader(eventReader, eventFilter);
        XMLEvent event = filteredEventReader.nextEvent();
        Iterator<Attribute> attributes = event.asStartElement().getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            String attributeName = attribute.getName().getLocalPart();
            if (attributeName.equals("processorId")) {
                processorId = attribute.getValue();
            }
            if (!attributeName.equals("processReport")) continue;
            processReport = Boolean.parseBoolean(attribute.getValue());
        }
        PeakIdentificationEntry peakIdentificationEntry = new PeakIdentificationEntry(processorId, processReport);
        batchJob.setPeakIdentificationEntry(peakIdentificationEntry);
        eventReader.close();
        bufferedInputStream.close();
    }

    private void readPeakOutputEntries(File file, IPeakIdentificationBatchJob batchJob, IProgressMonitor monitor) throws XMLStreamException, IOException {
        String converterId = "";
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        XMLEventReader eventReader = inputFactory.createXMLEventReader(bufferedInputStream, "UTF-8");
        ArrayList<String> acceptedElements = new ArrayList<String>();
        acceptedElements.add("OutputEntry");
        PeakIdentificationBatchJobEventFilter eventFilter = new PeakIdentificationBatchJobEventFilter(acceptedElements);
        XMLEventReader filteredEventReader = inputFactory.createFilteredReader(eventReader, eventFilter);
        while (filteredEventReader.hasNext()) {
            XMLEvent event = filteredEventReader.nextEvent();
            Iterator<Attribute> attributes = event.asStartElement().getAttributes();
            while (attributes.hasNext()) {
                Attribute attribute = attributes.next();
                String attributeName = attribute.getName().getLocalPart();
                if (!attributeName.equals("converterId")) continue;
                converterId = attribute.getValue();
            }
            event = eventReader.nextEvent();
            String outputFile = event.asCharacters().getData();
            PeakOutputEntry outputEntry = new PeakOutputEntry(outputFile, converterId);
            batchJob.getPeakOutputEntries().add(outputEntry);
        }
        eventReader.close();
        bufferedInputStream.close();
    }
}

