/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.util.ArrayList;
import org.eclipse.compare.internal.core.patch.DiffProject;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class PatchInaccessibleProjectsPage
extends WizardPage {
    private CheckboxTableViewer checkList;
    private Button checkAllButton;
    private Button uncheckAllButton;
    private WorkspacePatcher fPatcher;
    public static final String PATCH_INACCESSIBLE_PROJECTS_NAME = "PatchInaccessibleProjectsPage";

    public PatchInaccessibleProjectsPage(WorkspacePatcher patcher) {
        super(PATCH_INACCESSIBLE_PROJECTS_NAME, TeamUIMessages.PatchInaccessibleProjectsPage_title, null);
        this.setMessage(TeamUIMessages.PatchInaccessibleProjectsPage_message);
        this.fPatcher = patcher;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(272));
        this.setControl((Control)composite);
        Font parentFont = composite.getFont();
        this.checkList = CheckboxTableViewer.newCheckList((Composite)composite, (int)2816);
        this.checkList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.checkList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider(){

            public Color getForeground(Object element) {
                if (element instanceof IProject && !((IProject)element).exists()) {
                    return Display.getCurrent().getSystemColor(18);
                }
                return super.getForeground(element);
            }

            protected String decorateText(String input, Object element) {
                if (element instanceof IProject && !((IProject)element).exists()) {
                    return String.valueOf(input) + NLS.bind((String)TeamUIMessages.PatchInaccessibleProjectsPage_projectDoesNotExistInWorkspace, (Object)"");
                }
                return input;
            }
        });
        this.checkList.addCheckStateListener(event -> {
            IProject project = (IProject)event.getElement();
            if (event.getChecked() && !project.exists()) {
                this.checkList.setChecked((Object)project, false);
            }
        });
        this.checkList.setComparator((ViewerComparator)new ResourceComparator(1));
        Table table = this.checkList.getTable();
        GridData data = new GridData(272);
        data.horizontalSpan = 3;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)data);
        this.checkAllButton = new Button(composite, 0);
        this.checkAllButton.setText(TeamUIMessages.PatchInaccessibleProjectsPage_selectExisting);
        this.checkAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatchInaccessibleProjectsPage.this.setAllChecked(true);
            }
        });
        this.checkAllButton.setFont(parentFont);
        this.setButtonLayoutData(this.checkAllButton);
        this.uncheckAllButton = new Button(composite, 0);
        this.uncheckAllButton.setText(TeamUIMessages.PatchInaccessibleProjectsPage_deselectAll);
        this.uncheckAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatchInaccessibleProjectsPage.this.setAllChecked(false);
            }
        });
        this.uncheckAllButton.setFont(parentFont);
        this.setButtonLayoutData(this.uncheckAllButton);
        this.updateControls();
    }

    private void updateControls() {
        DiffProject[] diffProjects = this.fPatcher.getDiffProjects();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        if (diffProjects != null) {
            int i = 0;
            while (i < diffProjects.length) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(diffProjects[i].getName());
                if (!project.isAccessible()) {
                    projects.add(project);
                }
                ++i;
            }
        }
        this.checkList.setInput((Object)projects.toArray(new IProject[0]));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateControls();
        }
    }

    public IWizardPage getNextPage() {
        Control control = this.getControl();
        if (control != null && control.isVisible()) {
            return null;
        }
        return super.getNextPage();
    }

    public IProject[] getSelectedProjects() {
        Object[] elements = this.checkList.getCheckedElements();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        int i = 0;
        while (i < elements.length) {
            projects.add((IProject)elements[i]);
            ++i;
        }
        return projects.toArray(new IProject[0]);
    }

    private void setAllChecked(boolean checked) {
        int count = this.checkList.getTable().getItemCount();
        int i = 0;
        while (i < count) {
            IProject project = (IProject)this.checkList.getElementAt(i);
            if (project.exists()) {
                this.checkList.setChecked((Object)project, checked);
            }
            ++i;
        }
    }
}

