/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.peak.detector.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.peak.detector.core.IPeakDetectorSupplier;
import org.eclipse.chemclipse.chromatogram.peak.detector.core.IPeakDetectorSupport;
import org.eclipse.chemclipse.chromatogram.peak.detector.exceptions.NoPeakDetectorAvailableException;

public abstract class AbstractPeakDetectorSupport<S extends IPeakDetectorSupplier>
implements IPeakDetectorSupport {
    List<S> suppliers = new ArrayList<S>();

    public void add(S supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public List<String> getAvailablePeakDetectorIds() throws NoPeakDetectorAvailableException {
        this.arePeakDetectorsStored();
        ArrayList<String> availablePeakDetectors = new ArrayList<String>();
        for (IPeakDetectorSupplier supplier : this.suppliers) {
            availablePeakDetectors.add(supplier.getId());
        }
        return availablePeakDetectors;
    }

    protected S getSupplier(String peakDetectorId) throws NoPeakDetectorAvailableException {
        IPeakDetectorSupplier peakDetectorSupplier = null;
        this.arePeakDetectorsStored();
        if (peakDetectorId == null || peakDetectorId.equals("")) {
            throw new NoPeakDetectorAvailableException("There is no peak detector available with the following id: " + peakDetectorId + ".");
        }
        for (IPeakDetectorSupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(peakDetectorId)) continue;
            peakDetectorSupplier = supplier;
            break;
        }
        if (peakDetectorSupplier == null) {
            throw new NoPeakDetectorAvailableException("There is no peak detector available with the following id: " + peakDetectorId + ".");
        }
        return (S)peakDetectorSupplier;
    }

    @Override
    public String getPeakDetectorId(int index) throws NoPeakDetectorAvailableException {
        this.arePeakDetectorsStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoPeakDetectorAvailableException("There is no peak detector available with the following id: " + index + ".");
        }
        IPeakDetectorSupplier supplier = (IPeakDetectorSupplier)this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String[] getPeakDetectorNames() throws NoPeakDetectorAvailableException {
        this.arePeakDetectorsStored();
        ArrayList<String> integratorNames = new ArrayList<String>();
        for (IPeakDetectorSupplier supplier : this.suppliers) {
            integratorNames.add(supplier.getPeakDetectorName());
        }
        return integratorNames.toArray(new String[integratorNames.size()]);
    }

    private void arePeakDetectorsStored() throws NoPeakDetectorAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoPeakDetectorAvailableException();
        }
    }
}

