/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.pdfbox.extensions.settings;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.pdfbox.extensions.settings.IPageBaseConverter;
import org.eclipse.chemclipse.pdfbox.extensions.settings.IUnitConverter;
import org.eclipse.chemclipse.pdfbox.extensions.settings.PageBase;
import org.eclipse.chemclipse.pdfbox.extensions.settings.Unit;

public class ConverterFactory {
    private static final Map<Unit, IUnitConverter> UNIT_CONVERTER_MAP = new HashMap<Unit, IUnitConverter>();
    private static final Map<PageBase, IPageBaseConverter> PAGE_BASE_CONVERTER_MAP = new HashMap<PageBase, IPageBaseConverter>();

    public static IUnitConverter getInstance(final Unit unit) {
        if (!UNIT_CONVERTER_MAP.containsKey((Object)unit)) {
            IUnitConverter unitConverter = new IUnitConverter(){

                @Override
                public float getFactor() {
                    return unit.getFactor();
                }

                @Override
                public float convertToPt(float value) {
                    return value * this.getFactor();
                }

                @Override
                public float convertFromPt(float value) {
                    return value / this.getFactor();
                }
            };
            UNIT_CONVERTER_MAP.put(unit, unitConverter);
        }
        return UNIT_CONVERTER_MAP.get((Object)unit);
    }

    public static IPageBaseConverter getInstance(final PageBase pageBase) {
        if (!PAGE_BASE_CONVERTER_MAP.containsKey((Object)pageBase)) {
            IPageBaseConverter baseConverter = new IPageBaseConverter(){

                @Override
                public float getPositionX(float pageWidth, float x) {
                    return pageBase.getFactorWidth() * pageWidth + (pageBase.isSubtractWidth() ? -x : x);
                }

                @Override
                public float getPositionY(float pageHeight, float y) {
                    return pageBase.getFactorHeight() * pageHeight + (pageBase.isSubtractHeight() ? -y : y);
                }
            };
            PAGE_BASE_CONVERTER_MAP.put(pageBase, baseConverter);
        }
        return PAGE_BASE_CONVERTER_MAP.get((Object)pageBase);
    }
}

