/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.xy.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.csd.converter.io.AbstractChromatogramCSDReader;
import org.eclipse.chemclipse.csd.converter.supplier.xy.model.IVendorChromatogram;
import org.eclipse.chemclipse.csd.converter.supplier.xy.model.VendorChromatogram;
import org.eclipse.chemclipse.csd.converter.supplier.xy.model.VendorScan;
import org.eclipse.chemclipse.csd.converter.supplier.xy.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReader
extends AbstractChromatogramCSDReader {
    private static final Logger logger = Logger.getLogger(ChromatogramReader.class);

    public IChromatogramCSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        return this.readChromatogram(file, monitor);
    }

    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        return this.readChromatogram(file, monitor);
    }

    private IChromatogramCSD readChromatogram(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        VendorChromatogram chromatogram = new VendorChromatogram();
        chromatogram.setFile(file);
        boolean importSuccessful = this.readChromatogram(new BufferedReader(new FileReader(file)), chromatogram);
        if (!importSuccessful) {
            this.readChromatogram(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-16")), chromatogram);
        }
        int scanInterval = (chromatogram.getStopRetentionTime() - chromatogram.getStartRetentionTime()) / chromatogram.getNumberOfScans() + 1;
        int scanDelay = chromatogram.getStartRetentionTime() - scanInterval;
        scanDelay = scanDelay < 0 ? 0 : scanDelay;
        chromatogram.setScanInterval(scanInterval);
        chromatogram.setScanDelay(scanDelay);
        return chromatogram;
    }

    private boolean readChromatogram(BufferedReader bufferedReader, IVendorChromatogram chromatogram) {
        block23: {
            if (bufferedReader != null) {
                try {
                    try {
                        String line;
                        boolean autoDetectFormat = PreferenceSupplier.isAutoDetectFormat();
                        String delimiterFormat = PreferenceSupplier.getDelimiterFormat();
                        String retentionTimeFormat = PreferenceSupplier.getRetentionTimeFormat();
                        while ((line = bufferedReader.readLine()) != null) {
                            String[] values = null;
                            values = autoDetectFormat ? (line.contains("\t") ? line.split("\t") : (line.contains(",") ? line.split(",") : (line.contains(";") ? line.split(";") : line.split(" ")))) : line.split(delimiterFormat);
                            if (values == null || values.length < 2) continue;
                            try {
                                String value = values[0].trim();
                                int retentionTime = -1;
                                if (autoDetectFormat) {
                                    if (value.contains(".")) {
                                        double retentionTimeInMinutes = Double.parseDouble(value);
                                        retentionTime = (int)(retentionTimeInMinutes * 60000.0);
                                    } else {
                                        retentionTime = Integer.parseInt(value);
                                    }
                                } else if (retentionTimeFormat.equals("Minutes")) {
                                    double retentionTimeInMinutes = Double.parseDouble(value);
                                    retentionTime = (int)(retentionTimeInMinutes * 60000.0);
                                } else if (retentionTimeFormat.equals("Seconds")) {
                                    double retentionTimeInSeconds = Double.parseDouble(value);
                                    retentionTime = (int)(retentionTimeInSeconds * 1000.0);
                                } else {
                                    retentionTime = Integer.parseInt(value);
                                }
                                if (retentionTime < 0) continue;
                                float totalSignal = Float.parseFloat(values[1]);
                                VendorScan scan = new VendorScan(retentionTime, totalSignal);
                                chromatogram.addScan((IScan)scan);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.warn((Object)e);
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException e2) {
                            logger.warn((Object)e2);
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        logger.warn((Object)e);
                    }
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    logger.warn((Object)e);
                }
            }
        }
        return chromatogram.getNumberOfScans() > 0;
    }
}

