/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.AbstractIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.AreaSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IAreaSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IIntegrationSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IPeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IReportDecider;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.ISettingStatus;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IntegrationSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.SettingStatus;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIons;
import org.eclipse.chemclipse.wsd.model.core.IPeakWSD;

public abstract class AbstractPeakIntegrationSettings
extends AbstractIntegrationSettings
implements IPeakIntegrationSettings,
IReportDecider {
    @JsonIgnore
    private IMarkedIons selectedIons = new MarkedIons(IMarkedIons.IonMarkMode.INCLUDE);
    @JsonIgnore
    private IAreaSupport areaSupport = new AreaSupport();
    @JsonIgnore
    private IIntegrationSupport integratorSupport = new IntegrationSupport();
    @JsonIgnore
    private List<IReportDecider> reportDeciders = new ArrayList<IReportDecider>();

    public AbstractPeakIntegrationSettings() {
        this.reportDeciders.add(this.areaSupport);
        this.reportDeciders.add(this.integratorSupport);
    }

    @Override
    public ISettingStatus getSettingStatus(IPeak peak) {
        boolean report = this.report(peak);
        int startRetentionTime = 0;
        if (peak instanceof IPeakMSD) {
            startRetentionTime = ((IPeakMSD)peak).getPeakModel().getStartRetentionTime();
        } else if (peak instanceof IPeakCSD) {
            startRetentionTime = ((IPeakCSD)peak).getPeakModel().getStartRetentionTime();
        } else if (peak instanceof IPeakWSD) {
            startRetentionTime = ((IPeakWSD)peak).getPeakModel().getStartRetentionTime();
        }
        boolean sumOn = this.getAreaSupport().isAreaSumOn(startRetentionTime);
        SettingStatus status = new SettingStatus(report, sumOn);
        return status;
    }

    @Override
    public void addReportDecider(IReportDecider reportDecider) {
        this.reportDeciders.add(reportDecider);
    }

    @Override
    public void removeReportDecider(IReportDecider reportDecider) {
        this.reportDeciders.remove(reportDecider);
    }

    @Override
    public IMarkedIons getSelectedIons() {
        return this.selectedIons;
    }

    @Override
    public IAreaSupport getAreaSupport() {
        return this.areaSupport;
    }

    @Override
    public IIntegrationSupport getIntegrationSupport() {
        return this.integratorSupport;
    }

    @Override
    public boolean report(IPeak peak) {
        boolean report = true;
        for (IReportDecider reportDecider : this.reportDeciders) {
            if (reportDecider.report(peak)) continue;
            report = false;
            break;
        }
        return report;
    }
}

