/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.denoising.settings;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import org.eclipse.chemclipse.chromatogram.filter.settings.AbstractChromatogramFilterSettings;
import org.eclipse.chemclipse.support.settings.IntSettingsProperty;
import org.eclipse.chemclipse.support.settings.StringSettingsProperty;

public class FilterSettings
extends AbstractChromatogramFilterSettings {
    @JsonProperty(value="Ions To Remove", defaultValue="18;28;84;207")
    @JsonPropertyDescription(value="List the ions to remove, separated by a semicolon..")
    @StringSettingsProperty(regExp="(^$|((\\d+;?)+))", isMultiLine=false)
    private String ionsToRemove = "18;28;84;207";
    @JsonProperty(value="Ions To Preserve", defaultValue="103;104")
    @JsonPropertyDescription(value="List the ions to preserve, separated by a semicolon..")
    @StringSettingsProperty(regExp="(^$|((\\d+;?)+))", isMultiLine=false)
    private String ionsToPreserve = "103;104";
    @JsonProperty(value="Adjust Threshold Transitions", defaultValue="true")
    @JsonPropertyDescription(value="Adjust zero threshold transitions.")
    private boolean adjustThresholdTransitions = true;
    @JsonProperty(value="Number Used Ions For Coefficient", defaultValue="1")
    @JsonPropertyDescription(value="The number of used ions for coefficient calculation.")
    @IntSettingsProperty(minValue=1, maxValue=20)
    private int numberOfUsedIonsForCoefficient = 1;
    @JsonProperty(value="Segment Width", defaultValue="13")
    @IntSettingsProperty(minValue=5, maxValue=19, validation=IntSettingsProperty.Validation.ODD_NUMBER)
    private int segmentWidth = 13;

    public String getIonsToRemove() {
        return this.ionsToRemove;
    }

    public void setIonsToRemove(String ionsToRemove) {
        this.ionsToRemove = ionsToRemove;
    }

    public String getIonsToPreserve() {
        return this.ionsToPreserve;
    }

    public void setIonsToPreserve(String ionsToPreserve) {
        this.ionsToPreserve = ionsToPreserve;
    }

    public boolean isAdjustThresholdTransitions() {
        return this.adjustThresholdTransitions;
    }

    public void setAdjustThresholdTransitions(boolean adjustThresholdTransitions) {
        this.adjustThresholdTransitions = adjustThresholdTransitions;
    }

    public int getNumberOfUsedIonsForCoefficient() {
        return this.numberOfUsedIonsForCoefficient;
    }

    public void setNumberOfUsedIonsForCoefficient(int numberOfUsedIonsForCoefficient) {
        this.numberOfUsedIonsForCoefficient = numberOfUsedIonsForCoefficient <= 0 ? 1 : numberOfUsedIonsForCoefficient;
    }

    public int getSegmentWidth() {
        return this.segmentWidth;
    }

    public void setSegmentWidth(int segmentWidth) {
        this.segmentWidth = segmentWidth;
    }
}

