/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.savitzkygolay.core;

import java.util.Iterator;
import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.AbstractChromatogramSignalFilter;
import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.IChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.savitzkygolay.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.savitzkygolay.processor.SavitzkyGolayProcessor;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.savitzkygolay.settings.ChromatogramFilterSettings;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.matrix.ExtractedMatrix;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramFilter
extends AbstractChromatogramSignalFilter {
    public IChromatogramFilterResult process(IChromatogramSelectionMSD chromatogramSelection, IChromatogramFilterSettings filterSettings, IProgressMonitor monitor) {
        IChromatogramFilterResult chromatogramFilterResult;
        IChromatogramMSD chromatogramMSD = (IChromatogramMSD)chromatogramSelection.getChromatogram();
        ChromatogramFilterSettings settings = (ChromatogramFilterSettings)filterSettings;
        if (settings.getPerIonCalculation()) {
            ExtractedMatrix extractedMatrix = new ExtractedMatrix(chromatogramSelection);
            chromatogramFilterResult = this.filterProcess(extractedMatrix, filterSettings, monitor);
        } else {
            TotalScanSignalExtractor totalScanSignalExtractor = new TotalScanSignalExtractor((IChromatogram)chromatogramMSD);
            ITotalScanSignals totalSignals = totalScanSignalExtractor.getTotalScanSignals((IChromatogramSelection)chromatogramSelection, true);
            chromatogramFilterResult = this.filterProcess(totalSignals, filterSettings, monitor);
            totalSignals.setNegativeTotalSignalsToZero();
            Iterator itScan = totalSignals.iterator();
            if (chromatogramFilterResult.getResultStatus().equals((Object)ResultStatus.OK)) {
                while (itScan.hasNext()) {
                    Integer scan = (Integer)itScan.next();
                    IVendorMassSpectrum scanMSD = chromatogramMSD.getSupplierScan(scan.intValue());
                    ITotalScanSignal totalscanSignal = totalSignals.getTotalScanSignal(scan.intValue());
                    scanMSD.adjustTotalSignal(totalscanSignal.getTotalSignal());
                }
            }
        }
        return chromatogramFilterResult;
    }

    protected IChromatogramFilterResult applyFilter(ITotalScanSignals totalSignals, IChromatogramFilterSettings filterSettings, IProgressMonitor monitor) {
        return SavitzkyGolayProcessor.apply(totalSignals, (ChromatogramFilterSettings)filterSettings, monitor);
    }

    protected IChromatogramFilterResult applyFilter(ITotalScanSignals totalSignals, IProgressMonitor monitor) {
        ChromatogramFilterSettings chromatogramFilterSettings = PreferenceSupplier.getFilterSettings();
        return this.applyFilter(totalSignals, (IChromatogramFilterSettings)chromatogramFilterSettings, monitor);
    }

    protected IChromatogramFilterResult applyFilter(ExtractedMatrix extractedMatrix, IChromatogramFilterSettings filterSettings, IProgressMonitor monitor) {
        double[][] matrix = extractedMatrix.getMatrix();
        SavitzkyGolayProcessor.apply(matrix, (ChromatogramFilterSettings)filterSettings, monitor);
        extractedMatrix.updateSignal();
        return new ChromatogramFilterResult(ResultStatus.OK, "The Savitzky-Golay filter has been applied successfully.");
    }

    protected IChromatogramFilterResult applyFilter(ExtractedMatrix extractedMatrix, IProgressMonitor monitor) {
        ChromatogramFilterSettings chromatogramFilterSettings = PreferenceSupplier.getFilterSettings();
        return this.applyFilter(extractedMatrix, (IChromatogramFilterSettings)chromatogramFilterSettings, monitor);
    }

    public IChromatogramFilterResult filterProcess(ITotalScanSignals totalScanSignals, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        if (chromatogramFilterSettings == null) {
            return this.applyFilter(totalScanSignals, monitor);
        }
        return this.applyFilter(totalScanSignals, chromatogramFilterSettings, monitor);
    }

    private IChromatogramFilterResult filterProcess(ExtractedMatrix extractedMatrix, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        if (chromatogramFilterSettings == null) {
            return this.applyFilter(extractedMatrix, monitor);
        }
        return this.applyFilter(extractedMatrix, chromatogramFilterSettings, monitor);
    }
}

