/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.calculator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.savitzkygolay.processor.SavitzkyGolayProcessor;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonProvider;
import org.eclipse.chemclipse.msd.model.core.comparator.IonValueComparator;
import org.eclipse.chemclipse.processing.core.DefaultProcessingResult;
import org.eclipse.chemclipse.processing.core.IProcessingResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FilterSupplier {
    public IProcessingResult<Integer> applySavitzkyGolayFilter(List<? extends IIonProvider> massSpectra, int derivative, int order, int width, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)massSpectra.size());
        DefaultProcessingResult result = new DefaultProcessingResult();
        result.setProcessingResult((Object)0);
        for (IIonProvider iIonProvider : massSpectra) {
            this.applySavitzkyGolay(iIonProvider, derivative, order, width, (IProgressMonitor)subMonitor.split(1), (IProcessingResult<Integer>)result);
        }
        return result;
    }

    private void applySavitzkyGolay(IIonProvider massSpectrum, int derivative, int order, int width, IProgressMonitor monitor, IProcessingResult<Integer> result) {
        ArrayList<IIon> ions = new ArrayList<IIon>(massSpectrum.getIons());
        Collections.sort(ions, new IonValueComparator());
        double[] intensityValues = this.getIntensityValues(ions);
        SavitzkyGolayProcessor processor = new SavitzkyGolayProcessor();
        double[] smoothed = SavitzkyGolayProcessor.smooth(intensityValues, derivative, order, width, monitor);
        int i = 0;
        int smoothedIons = (Integer)result.getProcessingResult();
        for (IIon ion : ions) {
            try {
                ion.setAbundance((float)smoothed[i]);
                ++smoothedIons;
            }
            catch (AbundanceLimitExceededException e) {
                result.addWarnMessage("Savitzky-Golay", "Ion " + i + " of massspectrum can not be smoothed because the abundance limit is exceeded");
            }
            ++i;
        }
        result.setProcessingResult((Object)smoothedIons);
    }

    private double[] getIntensityValues(List<IIon> ions) {
        double[] intensityValues = new double[ions.size()];
        int counter = 0;
        for (IIon ion : ions) {
            intensityValues[counter++] = ion.getAbundance();
        }
        return intensityValues;
    }
}

