/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.IMassSpectrumFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.settings.IMassSpectrumFilterSettings;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;

public abstract class AbstractMassSpectrumFilter
implements IMassSpectrumFilter {
    private static final String DESCRIPTION = "Mass Spectrum Filter";

    public <T> IProcessingInfo<T> validate(IScanMSD massSpectrum, IMassSpectrumFilterSettings massSpectrumFilterSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(this.validateMassSpectrum(massSpectrum));
        processingInfo.addMessages(this.validateFilterSettings(massSpectrumFilterSettings));
        return processingInfo;
    }

    public <T> IProcessingInfo<T> validate(List<IScanMSD> massSpectra, IMassSpectrumFilterSettings massSpectrumFilterSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(this.validateMassSpectra(massSpectra));
        processingInfo.addMessages(this.validateFilterSettings(massSpectrumFilterSettings));
        return processingInfo;
    }

    private <T> IProcessingInfo<T> validateMassSpectrum(IScanMSD massSpectrum) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (massSpectrum == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The mass spectrum is not valid.");
        }
        return processingInfo;
    }

    private <T> IProcessingInfo<T> validateMassSpectra(List<IScanMSD> massSpectra) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (massSpectra == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The mass spectrum list is not valid.");
        }
        return processingInfo;
    }

    private <T> IProcessingInfo<T> validateFilterSettings(IMassSpectrumFilterSettings massSpectrumFilterSettings) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (massSpectrumFilterSettings == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The filter settings are not valid.");
        }
        return processingInfo;
    }
}

