/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.IChromatogramFilterSupplier;
import org.eclipse.chemclipse.chromatogram.filter.exceptions.NoChromatogramFilterSupplierAvailableException;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.ChromatogramFilterMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.IChromatogramFilterSupportMSD;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class ChromatogramFilterMSDProcessSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Chromatogram Filter";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            IChromatogramFilterSupportMSD support = ChromatogramFilterMSD.getChromatogramFilterSupport();
            ArrayList list = new ArrayList();
            for (String processorId : support.getAvailableFilterIds()) {
                list.add((IProcessSupplier<?>)new ChromatogramFilterMSDProcessorSupplier(support.getFilterSupplier(processorId), this));
            }
            return list;
        }
        catch (NoChromatogramFilterSupplierAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class ChromatogramFilterMSDProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IChromatogramFilterSettings> {
        private IChromatogramFilterSupplier supplier;

        public ChromatogramFilterMSDProcessorSupplier(IChromatogramFilterSupplier supplier, IProcessTypeSupplier parent) {
            super("ChromatogramFilterMSD." + supplier.getId(), supplier.getFilterName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.MSD});
            this.supplier = supplier;
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IChromatogramFilterSettings processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
                IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
                if (processSettings instanceof IChromatogramFilterSettings) {
                    messageConsumer.addMessages((MessageProvider)ChromatogramFilterMSD.applyFilter(chromatogramSelectionMSD, processSettings, this.supplier.getId(), monitor));
                } else {
                    messageConsumer.addMessages(ChromatogramFilterMSD.applyFilter(chromatogramSelectionMSD, this.supplier.getId(), monitor));
                }
            } else {
                messageConsumer.addWarnMessage(this.getName(), "Only MSD chromatogram supported, skipp processing");
            }
            return chromatogramSelection;
        }

        public boolean matchesId(String id) {
            return super.matchesId(id) || this.supplier.getId().equals(id);
        }
    }
}

