/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.methods;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.methods.ProcessEntryContainer;

public interface IProcessMethod
extends ProcessEntryContainer {
    public String getUUID();

    @Override
    public String getName();

    public String getCategory();

    public String getOperator();

    @Override
    public String getDescription();

    public boolean isFinal();

    default public File getSourceFile() {
        return null;
    }

    public Set<DataCategory> getDataCategories();

    public Map<String, String> getMetaData();

    default public boolean contentEquals(IProcessMethod other, boolean includeMetadata) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.isFinal() != other.isFinal()) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getCategory().equals(other.getCategory())) {
            return false;
        }
        if (!this.getDescription().equals(other.getDescription())) {
            return false;
        }
        if (!this.getOperator().equals(other.getOperator())) {
            return false;
        }
        if (this.getNumberOfEntries() != other.getNumberOfEntries()) {
            return false;
        }
        if (includeMetadata && !this.getMetaData().equals(other.getMetaData())) {
            return false;
        }
        return this.entriesEquals(other);
    }
}

