/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.processing.converter;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.processing.converter.ISupplierFileIdentifier;

public abstract class AbstractSupplierFileIdentifier
implements ISupplierFileIdentifier {
    private final List<ISupplier> suppliers;

    public AbstractSupplierFileIdentifier(List<ISupplier> suppliers) {
        this.suppliers = suppliers;
    }

    @Override
    public boolean isSupplierFile(File file) {
        block3: {
            block2: {
                if (!file.isFile()) break block2;
                for (ISupplier supplier : this.getSupplier()) {
                    if (!AbstractSupplierFileIdentifier.isValidFileSupplier(file, supplier)) continue;
                    return true;
                }
                break block3;
            }
            if (!file.isDirectory()) break block3;
            for (ISupplier supplier : this.getSupplier()) {
                if (!AbstractSupplierFileIdentifier.isValidDirectorySupplier(file, supplier)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<ISupplier> getSupplier(File file) {
        ArrayList<ISupplier> list;
        block3: {
            block2: {
                list = new ArrayList<ISupplier>();
                if (!file.isFile()) break block2;
                for (ISupplier supplier : this.getSupplier()) {
                    if (!AbstractSupplierFileIdentifier.isValidFileSupplier(file, supplier) || !this.isMatchMagicNumber(file)) continue;
                    list.add(supplier);
                }
                break block3;
            }
            if (!file.isDirectory()) break block3;
            for (ISupplier supplier : this.getSupplier()) {
                if (!AbstractSupplierFileIdentifier.isValidDirectorySupplier(file, supplier) || !this.isMatchMagicNumber(file)) continue;
                list.add(supplier);
            }
        }
        return list;
    }

    protected static boolean isValidFileSupplier(File file, ISupplier supplier) {
        boolean hasExtension;
        String extension = file.toString().toLowerCase();
        String supplierExtension = supplier.getFileExtension().toLowerCase();
        boolean bl = hasExtension = supplierExtension != null && !supplierExtension.isEmpty();
        if (hasExtension) {
            if (supplierExtension.contains("#")) {
                String extensionMatcher = AbstractSupplierFileIdentifier.getExtensionMatcher(supplierExtension);
                if (extension.matches(extensionMatcher)) {
                    return supplier.isImportable();
                }
            } else if (extension.endsWith(supplierExtension) && supplier.isImportable()) {
                return true;
            }
        } else {
            return supplier.isImportable();
        }
        return false;
    }

    protected static boolean isValidDirectorySupplier(File file, ISupplier supplier) {
        String directory = file.toString().toUpperCase();
        String directoryExtension = supplier.getDirectoryExtension();
        if (!"".equals(directoryExtension)) {
            if (directoryExtension.contains("#")) {
                if (directoryExtension.startsWith(".")) {
                    directoryExtension = directoryExtension.substring(1, directoryExtension.length());
                }
                String[] directoryParts = directoryExtension.split("#");
                return AbstractSupplierFileIdentifier.isDirectoryPatternMatch(file, directoryParts, 0);
            }
            if ((directoryExtension = directoryExtension.toUpperCase()) != "" && directory.endsWith(directoryExtension) && supplier.isImportable()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<ISupplier> getSupplier() {
        return this.suppliers;
    }

    public boolean isSupplierFileDirectory(File file) {
        return this.isSupplierFileDirectory(file);
    }

    private static boolean isDirectoryPatternMatch(File file, String[] directoryParts, int index) {
        if (file.isDirectory() && index < directoryParts.length && file.getName().matches(directoryParts[index])) {
            if (++index == directoryParts.length) {
                return true;
            }
            File[] listFiles = file.listFiles();
            if (listFiles != null) {
                File[] fileArray = listFiles;
                int n = listFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File subFile = fileArray[n2];
                    if (AbstractSupplierFileIdentifier.isDirectoryPatternMatch(subFile, directoryParts, index)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isMatchMagicNumber(File file) {
        for (ISupplier supplier : this.getSupplier()) {
            if (!supplier.isMatchMagicNumber(file)) continue;
            return true;
        }
        return false;
    }

    private static String getExtensionMatcher(String supplierExtension) {
        String extensionMatcher = supplierExtension.replaceAll("#", "[0-9]");
        return extensionMatcher.replace(".", ".*\\.");
    }
}

