/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.core;

import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.AbstractChromatogramFilterMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.calculator.IMassChromatographicQualityResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.calculator.MassChromatographicQualityCalculator;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.exceptions.CodaCalculatorException;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.exceptions.FilterException;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.settings.FilterSettings;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramFilter
extends AbstractChromatogramFilterMSD {
    private static WindowSize MOVING_AVERAGE_WINDOW = WindowSize.WIDTH_5;

    public IProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, chromatogramFilterSettings);
        if (!processingInfo.hasErrorMessages() && chromatogramFilterSettings instanceof FilterSettings) {
            try {
                FilterSettings filterSettings = (FilterSettings)chromatogramFilterSettings;
                this.applyCodaFilter(chromatogramSelection, filterSettings);
                processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.OK, "The chromatogram selection has been successfully cleaned by the coda algorithm."));
            }
            catch (FilterException e) {
                processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.EXCEPTION, e.getMessage()));
            }
        }
        return processingInfo;
    }

    public IProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) {
        FilterSettings chromatogramFilterSettings = PreferenceSupplier.getChromatogramFilterSettings();
        return this.applyFilter(chromatogramSelection, (IChromatogramFilterSettings)chromatogramFilterSettings, monitor);
    }

    private void applyCodaFilter(IChromatogramSelectionMSD chromatogramSelection, FilterSettings filterSettings) throws FilterException {
        IMarkedIons excludedIons;
        try {
            IMassChromatographicQualityResult result = MassChromatographicQualityCalculator.calculate(chromatogramSelection, filterSettings.getCodaThreshold(), MOVING_AVERAGE_WINDOW);
            excludedIons = result.getExcludedIons();
        }
        catch (CodaCalculatorException e) {
            throw new FilterException("A failure occured while calculating the coda mass chromatographic quality.");
        }
        if (excludedIons == null) {
            throw new FilterException("The calculated excluded ions instance is null.");
        }
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        int scan = startScan;
        while (scan <= stopScan) {
            IVendorMassSpectrum supplierMassSpectrum = chromatogram.getSupplierScan(scan);
            supplierMassSpectrum.removeIons(excludedIons);
            ++scan;
        }
    }
}

