/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client.diego;

import java.util.Map;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.util.CloudUtil;
import org.cloudfoundry.client.lib.util.JsonUtil;
import org.eclipse.cft.server.core.internal.client.RestUtils;
import org.springframework.web.client.RestTemplate;

public class CFInfo {
    protected final RestTemplate restTemplate;
    private String ccUrl;
    private Map<String, Object> infoMap;

    public CFInfo(CloudCredentials creds, String url, HttpProxyConfiguration proxyConf, boolean selfSigned) {
        this.restTemplate = RestUtils.createRestTemplate(proxyConf, selfSigned, false);
        this.ccUrl = url;
    }

    public String getAuthorizationUrl() {
        return this.getProp("authorization_endpoint");
    }

    public String getCloudControllerUrl() {
        return this.ccUrl;
    }

    public String getCloudControllerApiVersion() {
        return this.getProp("api_version");
    }

    public String getProp(String name) {
        Map<String, Object> map = this.getMap();
        if (map != null) {
            return (String)CloudUtil.parse(String.class, (Object)map.get(name));
        }
        return null;
    }

    protected Map<String, Object> getMap() {
        if (this.infoMap == null) {
            String infoV2Json = (String)this.restTemplate.getForObject(this.getUrl("/v2/info"), String.class, new Object[0]);
            this.infoMap = JsonUtil.convertJsonToMap((String)infoV2Json);
        }
        return this.infoMap;
    }

    private String getUrl(String path) {
        return String.valueOf(this.ccUrl) + path;
    }
}

