/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.common.skeleton;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.xmlpivot.common.skeleton.AbstractModelWalker;
import org.polarsys.capella.xmlpivot.common.skeleton.ModelWalkerHelper;

public class SystemEngineeringWalker
extends AbstractModelWalker {
    @Override
    public void accept(EObject eObject_p, ModelWalkerHelper helper) {
        SystemEngineering engineering = (SystemEngineering)eObject_p;
        OperationalAnalysis oa = SystemEngineeringExt.getOwnedOperationalAnalysis((SystemEngineering)engineering);
        SystemAnalysis sa = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)engineering);
        LogicalArchitecture la = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)engineering);
        PhysicalArchitecture pa = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)engineering);
        EPBSArchitecture epbs = SystemEngineeringExt.getEPBSArchitecture((SystemEngineering)engineering);
        int index = 0;
        if (oa == null) {
            oa = helper.getOperationalAnalysis();
            if (oa != null) {
                engineering.getOwnedArchitectures().add(index++, (Object)oa);
            }
        } else {
            engineering.getOwnedArchitectures().move(index++, (Object)oa);
        }
        if (sa == null) {
            sa = helper.getSystemAnalysis();
            if (sa != null) {
                engineering.getOwnedArchitectures().add(index++, (Object)sa);
            }
        } else {
            engineering.getOwnedArchitectures().move(index++, (Object)sa);
        }
        if (la == null) {
            la = helper.getLogicalArchitecture();
            if (la != null) {
                engineering.getOwnedArchitectures().add(index++, (Object)la);
            }
        } else {
            engineering.getOwnedArchitectures().move(index++, (Object)la);
        }
        if (pa == null) {
            pa = helper.getPhysicalArchitecture();
            if (pa != null) {
                engineering.getOwnedArchitectures().add(index++, (Object)pa);
            }
        } else {
            engineering.getOwnedArchitectures().move(index++, (Object)pa);
        }
        if (epbs == null) {
            epbs = helper.getEPBSArchitecture();
            if (epbs != null) {
                engineering.getOwnedArchitectures().add(index++, (Object)epbs);
            }
        } else {
            engineering.getOwnedArchitectures().move(index++, (Object)epbs);
        }
        AbstractFunction rootOperationalActivity = BlockArchitectureExt.getRootFunction((BlockArchitecture)oa);
        AbstractFunction rootSystemFunction = BlockArchitectureExt.getRootFunction((BlockArchitecture)sa);
        AbstractFunction rootLogicalFunction = BlockArchitectureExt.getRootFunction((BlockArchitecture)la);
        AbstractFunction rootPhysicalFunction = BlockArchitectureExt.getRootFunction((BlockArchitecture)pa);
        if (rootSystemFunction != null && rootOperationalActivity != null) {
            this.realize(rootSystemFunction, rootOperationalActivity);
        }
        if (rootLogicalFunction != null && rootSystemFunction != null) {
            this.realize(rootLogicalFunction, rootSystemFunction);
        }
        if (rootPhysicalFunction != null && rootLogicalFunction != null) {
            this.realize(rootPhysicalFunction, rootLogicalFunction);
        }
    }

    private void realize(AbstractFunction realizingFunction, AbstractFunction realizedFunction) {
        for (FunctionRealization re : realizingFunction.getOwnedFunctionRealizations()) {
            if (re.getSourceElement() != realizingFunction || re.getTargetElement() != realizedFunction) continue;
            return;
        }
        FunctionRealization realization = FaFactory.eINSTANCE.createFunctionRealization();
        realization.setSourceElement((TraceableElement)realizingFunction);
        realization.setTargetElement((TraceableElement)realizedFunction);
        realizingFunction.getOwnedFunctionRealizations().add((Object)realization);
    }
}

