/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.merge;

import java.util.Collection;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethod;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.specification.ext.ResourceScopeDefinition;
import org.eclipse.emf.diffmerge.ui.specification.ext.URIScopeDefinition;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.xmlpivot.ResourceLoader;
import org.polarsys.capella.xmlpivot.importer.ImportAsNewProjectRunner;
import org.polarsys.capella.xmlpivot.merge.specification.XMLPivotComparisonFactory;
import org.polarsys.capella.xmlpivot.merge.temp.XMLPivotDiffMergeEditorInput;

public class CompareEditorInputFactory {
    private final ImportAsNewProjectRunner importAsNewProjectRunner;
    private final ResourceLoader loader;
    private final EditingDomain editingDomain;

    public CompareEditorInputFactory(EditingDomain domain, ImportAsNewProjectRunner importAsNewProjectRunner_p, ResourceLoader loader_p) {
        this.importAsNewProjectRunner = importAsNewProjectRunner_p;
        this.loader = loader_p;
        this.editingDomain = domain;
    }

    public CompareEditorInput create(URI capellaModelURI, URI pivotModelURI, boolean dynamic, ResourceSet set_p, IProgressMonitor monitor_p) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)monitor_p, (int)100);
        Resource xmlPivotResource = this.loader.load(set_p, pivotModelURI);
        this.importAsNewProjectRunner.run((Collection)xmlPivotResource.getContents(), "XML Pivot Import", dynamic, (IProgressMonitor)monitor.newChild(100));
        xmlPivotResource.unload();
        ResourceImpl imported = new ResourceImpl(URI.createURI((String)("xmlPivotSource_" + pivotModelURI.lastSegment() + "_" + EcoreUtil.generateUUID()), (boolean)true));
        imported.getContents().add((Object)this.importAsNewProjectRunner.getProjectHunk());
        imported.getContents().addAll(this.importAsNewProjectRunner.getOtherHunks());
        this.editingDomain.getResourceSet().getResources().add((Object)imported);
        IComparisonMethod spec = new XMLPivotComparisonFactory().createComparisonMethod((IModelScopeDefinition)new URIScopeDefinition(capellaModelURI, null, true), (IModelScopeDefinition)new ResourceScopeDefinition((Resource)imported, "XML Pivot Import", false), null);
        return new XMLPivotDiffMergeEditorInput(spec, (Resource)imported){
            private final /* synthetic */ Resource val$imported;
            {
                this.val$imported = resource;
                super($anonymous0);
            }

            public void disposeResources() {
                super.disposeResources();
                CompareEditorInputFactory.this.editingDomain.getResourceSet().getResources().remove((Object)this.val$imported);
            }
        };
    }
}

