/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.data.fa;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OrientationPortKind implements Enumerator
{
    UNSET(0, "UNSET", "UNSET"),
    IN(1, "IN", "IN"),
    OUT(2, "OUT", "OUT"),
    INOUT(3, "INOUT", "INOUT");

    public static final int UNSET_VALUE = 0;
    public static final int IN_VALUE = 1;
    public static final int OUT_VALUE = 2;
    public static final int INOUT_VALUE = 3;
    private static final OrientationPortKind[] VALUES_ARRAY;
    public static final List<OrientationPortKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OrientationPortKind[]{UNSET, IN, OUT, INOUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OrientationPortKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OrientationPortKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OrientationPortKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OrientationPortKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OrientationPortKind get(int value) {
        switch (value) {
            case 0: {
                return UNSET;
            }
            case 1: {
                return IN;
            }
            case 2: {
                return OUT;
            }
            case 3: {
                return INOUT;
            }
        }
        return null;
    }

    private OrientationPortKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

