/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.ui.attach;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.xmlpivot.common.predicates.EMFPredicates;

public class AttachmentHelperDialog
extends Dialog {
    private final EObject fragmentHolder;
    private final Collection<EObject> context;
    private TreeViewer contextTreeViewer;
    private TreeViewer fragmentTreeViewer;

    public AttachmentHelperDialog(Shell parentShell, EObject fragmentHolder_p, Collection<? extends EObject> context_p) {
        super(parentShell);
        this.fragmentHolder = fragmentHolder_p;
        this.context = new ArrayList<EObject>(context_p);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new FillLayout(256));
        this.fragmentTreeViewer = new TreeViewer(container, 2048);
        this.contextTreeViewer = new TreeViewer(container, 2048);
        ComposedAdapterFactory af = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        af.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.contextTreeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)af));
        this.fragmentTreeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)af));
        this.contextTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)af));
        this.fragmentTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)af));
        this.fragmentTreeViewer.setInput((Object)this.fragmentHolder);
        this.contextTreeViewer.setInput((Object)new MultiRootItemContentProvider(this.context));
        this.fragmentTreeViewer.addDragSupport(2, new Transfer[]{LocalTransfer.getInstance()}, (DragSourceListener)new ViewerDragAdapter((Viewer)this.fragmentTreeViewer));
        this.contextTreeViewer.addDropSupport(2, new Transfer[]{LocalTransfer.getInstance()}, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)TransactionHelper.getEditingDomain((EObject)this.fragmentHolder), (Viewer)this.contextTreeViewer));
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    static class MultiRootItemContentProvider
    implements IStructuredItemContentProvider {
        final Collection<? extends EObject> rootElements;

        public MultiRootItemContentProvider(Collection<? extends EObject> elements) {
            this.rootElements = elements;
        }

        public Collection<?> getElements(Object object_p) {
            return Collections2.filter(this.rootElements, (Predicate)EMFPredicates.isRootContainer());
        }
    }
}

