/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.docgen.util.CapellaDataValueServices;
import org.polarsys.capella.docgen.util.CapellaServices;

public class CapellaDataTypeService {
    private CapellaDataTypeService() {
    }

    public static List<String> getFeatures(EObject eObject) {
        DataValue nullValue;
        DataValue maxLength;
        DataValue maxValue;
        DataValue minLength;
        ArrayList<String> ret = new ArrayList<String>();
        if (!(eObject instanceof DataType)) {
            return ret;
        }
        DataType dataType = (DataType)eObject;
        ret.add("<b>Is Abstract\t:\t</b>" + dataType.isAbstract());
        ret.add("<b>Is Discrete\t:\t</b>" + dataType.isDiscrete());
        DataValue minValue = CapellaDataTypeService.getMinValue(dataType);
        if (minValue != null) {
            ret.add("<b>Min Value: </b>" + CapellaDataValueServices.getSimpleValueOfDataValue(minValue) + (minValue instanceof NumericValue && ((NumericValue)minValue).getUnit() != null ? " " + CapellaDataValueServices.getUnitOfNumericValue((NumericValue)minValue) : ""));
        }
        if ((minLength = CapellaDataTypeService.getMinLength(dataType)) != null) {
            ret.add("<b>Min Length: </b>" + CapellaDataValueServices.getSimpleValueOfDataValue(minLength));
        }
        if ((maxValue = CapellaDataTypeService.getMaxValue(dataType)) != null) {
            ret.add("<b>Max Value: </b>" + CapellaDataValueServices.getSimpleValueOfDataValue(maxValue) + (maxValue instanceof NumericValue && ((NumericValue)maxValue).getUnit() != null ? " " + CapellaDataValueServices.getUnitOfNumericValue((NumericValue)maxValue) : ""));
        }
        if ((maxLength = CapellaDataTypeService.getMaxLength(dataType)) != null) {
            ret.add("<b>Max Length: </b>" + CapellaDataValueServices.getSimpleValueOfDataValue(maxLength));
        }
        if (dataType.getDefaultValue() != null) {
            ret.add("<b>Default\t:\t</b>" + CapellaDataValueServices.getValueOfDataValue(dataType.getDefaultValue()));
        }
        if ((nullValue = CapellaDataTypeService.getNullValue(dataType)) != null) {
            ret.add("<b>Null Value: </b>" + CapellaDataValueServices.getSimpleValueOfDataValue(nullValue));
        }
        if (dataType.getPattern() != null) {
            ret.add("<b>Pattern\t:\t</b>" + dataType.getPattern());
        }
        return ret;
    }

    public static Collection<String> getTypeOf(DataType dataType, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        EList typedElements = dataType.getTypedElements();
        typedElements.stream().filter(tE -> tE instanceof ExchangeItemElement || tE instanceof Property).forEach(elem -> {
            String currentStringValue;
            boolean propertyOK;
            EObject container = elem.eContainer();
            boolean exchangeItemOK = elem instanceof ExchangeItemElement && container instanceof ExchangeItem;
            boolean bl = propertyOK = elem instanceof Property && container instanceof Class;
            if ((exchangeItemOK || propertyOK) && !ret.contains(currentStringValue = String.valueOf(CapellaServices.getImageLinkFromElement(container, projectName, outputFolder)) + " " + CapellaServices.getHyperlinkFromElement(container))) {
                ret.add(currentStringValue);
            }
        });
        return ret;
    }

    public static Collection<String> getLiterals(CapellaElement element, String projectName, String outputFolder) {
        ArrayList<String> literals = new ArrayList<String>();
        ArrayList dataValues = new ArrayList();
        if (element instanceof BooleanType) {
            dataValues.addAll(((BooleanType)element).getOwnedLiterals());
        } else if (element instanceof Enumeration) {
            dataValues.addAll(((Enumeration)element).getOwnedLiterals());
        }
        for (DataValue currentDataValue : dataValues) {
            literals.add(CapellaDataValueServices.getDataValueLiteralInformation(currentDataValue, projectName, outputFolder));
        }
        return literals;
    }

    private static DataValue getMinValue(DataType dataType) {
        return CapellaDataTypeService.getMethodDataValue(dataType, "getOwnedMinValue");
    }

    private static DataValue getMinLength(DataType dataType) {
        return CapellaDataTypeService.getMethodDataValue(dataType, "getOwnedMinLength");
    }

    private static DataValue getMaxValue(DataType dataType) {
        return CapellaDataTypeService.getMethodDataValue(dataType, "getOwnedMaxValue");
    }

    private static DataValue getMaxLength(DataType dataType) {
        return CapellaDataTypeService.getMethodDataValue(dataType, "getOwnedMaxLength");
    }

    private static DataValue getNullValue(DataType dataType) {
        return CapellaDataTypeService.getMethodDataValue(dataType, "getOwnedNullValue");
    }

    private static DataValue getMethodDataValue(DataType dataType, String methodName) {
        try {
            Method method = dataType.getClass().getMethod(methodName, new java.lang.Class[0]);
            Object result = method.invoke((Object)dataType, new Object[0]);
            if (result instanceof DataValue) {
                return (DataValue)result;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

