/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.configuration.ui.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.tools.api.command.semantic.RemoveSemanticResourceCommand;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.EObjectWrapper;
import org.polarsys.capella.configuration.Configuration;
import org.polarsys.capella.configuration.ConfigurationElement;
import org.polarsys.capella.configuration.ConfigurationFactory;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.docgen.configuration.ui.Activator;
import org.polarsys.capella.docgen.configuration.ui.Messages;
import org.polarsys.capella.docgen.util.DocGenHtmlCapellaControl;

public class ConfigurationUtils {
    public static final Color COLOR_ELEMENT_WITH_NO_HTML_DOCUMENTATION = new Color((Device)Display.getCurrent(), 180, 180, 180);
    private String message = "";
    private static ConfigurationUtils INSTANCE = new ConfigurationUtils();

    private ConfigurationUtils() {
    }

    public static ConfigurationUtils getInstance() {
        return INSTANCE;
    }

    public List<EObject> getElementsFromConfigurationFile(String fileName, Session session, IProgressMonitor monitor) {
        this.setMessage("");
        int nbResources = session.getSemanticResources().size();
        try {
            AddSemanticResourceCommand addSemanticResourceCommand = new AddSemanticResourceCommand(session, URI.createFileURI((String)fileName), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)addSemanticResourceCommand);
        }
        catch (Exception e) {
            this.setMessage(Messages.ConfigurationUtils_1);
            return new ArrayList<EObject>();
        }
        if (session.getSemanticResources().size() > nbResources + 1) {
            session.getTransactionalEditingDomain().getCommandStack().undo();
            this.setMessage(Messages.ConfigurationUtils_2);
            return new ArrayList<EObject>();
        }
        if (session.getSemanticResources().size() == nbResources) {
            this.setMessage(Messages.ConfigurationUtils_3);
            return new ArrayList<EObject>();
        }
        Resource configurationResource = session.getTransactionalEditingDomain().getResourceSet().getResource(URI.createFileURI((String)fileName), true);
        ArrayList<EObject> configurationElements = new ArrayList<EObject>();
        if (!configurationResource.getContents().isEmpty() && configurationResource.getContents().get(0) instanceof Configuration) {
            Configuration configuration = (Configuration)configurationResource.getContents().get(0);
            for (ConfigurationElement element : configuration.getConfigurationElements()) {
                if (element.getReference().eIsProxy()) continue;
                configurationElements.add(element.getReference());
            }
        }
        RemoveSemanticResourceCommand removeSemanticResourceCommand = new RemoveSemanticResourceCommand(session, configurationResource, (IProgressMonitor)new SubProgressMonitor(monitor, 1), false);
        session.getTransactionalEditingDomain().getCommandStack().execute((Command)removeSemanticResourceCommand);
        return configurationElements;
    }

    public void createConfigurationResource(String fileName, Collection<EObject> selectedElements) {
        this.setMessage("");
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource configurationResource = resourceSet.createResource(URI.createFileURI((String)fileName));
        Configuration configuration = ConfigurationFactory.eINSTANCE.createConfiguration();
        for (EObject selectedElement : selectedElements) {
            ConfigurationElement configurationElement = ConfigurationFactory.eINSTANCE.createConfigurationElement();
            configurationElement.setReference(selectedElement);
            configuration.getConfigurationElements().add((Object)configurationElement);
        }
        configurationResource.getContents().add((Object)configuration);
        try {
            configurationResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e1) {
            this.setMessage(Messages.ConfigurationUtils_5);
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.docgen.configuration.ui", e1.getMessage()));
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean canGenerateHtmlDocumentationFor(Object object) {
        Object candidate = object;
        if (candidate instanceof EObjectWrapper) {
            candidate = ((EObjectWrapper)object).getElement();
        }
        if (candidate instanceof EObject) {
            EObject eObject = (EObject)candidate;
            return this.canGenerateHtmlDocumentationFor(eObject);
        }
        return false;
    }

    public boolean canGenerateHtmlDocumentationFor(EObject eObject) {
        if (eObject instanceof CapellaElement) {
            return this.canGenerateHtmlDocumentationFor((CapellaElement)eObject);
        }
        return eObject instanceof DModelElement || eObject instanceof DRepresentationElement;
    }

    public boolean canGenerateHtmlDocumentationFor(CapellaElement capellaElement) {
        return DocGenHtmlCapellaControl.isPageCandidate((CapellaElement)capellaElement);
    }

    public boolean htmlDocumentationGenerationGeneratesIntoParentPage(EObject eObject) {
        if (eObject instanceof CapellaElement) {
            return this.htmlDocumentationGenerationGeneratesIntoParentPage((CapellaElement)eObject);
        }
        return eObject instanceof DRepresentationDescriptor || eObject instanceof DRepresentation;
    }

    public boolean htmlDocumentationGenerationGeneratesIntoParentPage(CapellaElement capellaElement) {
        return DocGenHtmlCapellaControl.isPageCandidateForAnyElement((CapellaElement)capellaElement);
    }
}

