/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.ui.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.docgen.ui.Activator;
import org.polarsys.kitalpha.doc.gen.business.core.ui.wizards.HTMLDocumentationGenerationWizard;

public class HTMLDocumentationGenerationAction
extends BaseSelectionListenerAction {
    private static final URI CAPELLA_LAUNCHER_URI = URI.createURI((String)"platform:/plugin/org.polarsys.capella.docgen.ui/egf/capellalauncher.fcore#_zup7kAkdEeCBJtEcjZDVOA");

    public HTMLDocumentationGenerationAction() {
        super("HTML Documentation Generation");
        this.setImageDescriptor(Activator.getImageDescriptor("icons/full/ctool16/binary-16x16.png"));
    }

    protected HTMLDocumentationGenerationAction(String text) {
        super(text);
    }

    public void run() {
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        HTMLDocumentationGenerationWizard wizard = new HTMLDocumentationGenerationWizard(structuredSelection){

            protected Map<String, URI> getLaunchersURI() {
                IConfigurationElement[] config;
                HashMap<String, URI> map = new HashMap<String, URI>();
                map.put("Default Launcher", CAPELLA_LAUNCHER_URI);
                IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.capella.docgen.ui.launcher");
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                    if (configurationElement.getName().equals("launcher")) {
                        String nameString = configurationElement.getAttribute("name");
                        String uriString = configurationElement.getAttribute("uri");
                        map.put(nameString, URI.createURI((String)uriString));
                    }
                    ++n2;
                }
                return map;
            }
        };
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
        dialog.open();
    }

    public void updateSatus() {
        boolean enable = false;
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        Object element = structuredSelection.getFirstElement();
        if (element instanceof IResource) {
            URI uri = URI.createPlatformResourceURI((String)((IResource)element).getFullPath().toString(), (boolean)true);
            for (Session currentSession : SessionManager.INSTANCE.getSessions()) {
                if (currentSession.getSessionResource() == null || !currentSession.getSessionResource().getURI().equals(uri)) continue;
                enable = true;
            }
            this.setEnabled(enable);
        }
    }
}

