/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.internal.context;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.producer.context.IProductionContext;
import org.eclipse.egf.core.producer.context.ProductionContext;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.egf.model.fcore.ModelElement;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.context.IModelElementProductionContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelElementProductionContext<P extends ModelElement, T extends ModelElement>
extends ProductionContext<P, T>
implements IModelElementProductionContext<P, T> {
    public ModelElementProductionContext(ProjectBundleSession projectBundleSession, P element, String name) {
        super(projectBundleSession, element, name);
    }

    public ModelElementProductionContext(IProductionContext<?, ?> parent, ProjectBundleSession projectBundleSession, P element, String name) {
        super(parent, projectBundleSession, element, name);
    }

    public Bundle getBundle(String id) throws InvocationException {
        try {
            ModelElement modelElement = (ModelElement)this.getElement();
            IPlatformFcore fcore = null;
            if (modelElement.eResource() != null && modelElement.eResource() instanceof IPlatformFcoreProvider) {
                fcore = ((IPlatformFcoreProvider)modelElement.eResource()).getIPlatformFcore();
            }
            if (fcore == null) {
                throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.Fcore_not_found, (Object)EcoreUtil.getURI((EObject)modelElement).trimFragment()), null)));
            }
            if (fcore.isRuntime()) {
                return Platform.getBundle((String)id);
            }
            IPlatformBundle bundle = EGFPlatformPlugin.getPlatformManager().getPlatformBundle(id);
            if (bundle != null) {
                if (bundle.isWorkspace()) {
                    return this._projectBundleSession.getBundle(id);
                }
                if (bundle.getBundle() != null) {
                    return bundle.getBundle();
                }
            }
            throw new InvocationException((Throwable)new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.TargetPlatform_ExtensionPoint_no_bundle, (Object)id), null)));
        }
        catch (CoreException ce) {
            throw new InvocationException((Throwable)ce);
        }
    }
}

