/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.multiphases;

import java.util.Collection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.transition.common.context.TransitionContext;
import org.polarsys.capella.core.transition.system.helpers.ContextHelper;
import org.polarsys.capella.transition.system2subsystem.context.SubSystemContextHelper;
import org.polarsys.capella.transition.system2subsystem.crossphases.handlers.attachment.CrossPhasesAttachmentHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class MultiphasesContext
extends TransitionContext {
    private Mapping mapping;

    public MultiphasesContext(Collection<?> selection) {
        this.put("TRANSPOSER_SELECTION", selection);
        this.put("SAVE_REQUIRED", Boolean.TRUE);
    }

    public Collection<? extends PhysicalComponent> getSelectedPhysicalComponents() {
        return (Collection)this.get("TRANSITION_SOURCES");
    }

    public void reset() {
        Collection transformedElementsCollection;
        Collection incompleteElementsCollection = (Collection)this.get("INCOMPLETE_ELEMENTS");
        if (incompleteElementsCollection != null) {
            incompleteElementsCollection.clear();
        }
        if ((transformedElementsCollection = (Collection)this.get("TRANSFORMED_ELEMENTS")) != null) {
            transformedElementsCollection.clear();
        }
        CrossPhasesAttachmentHelper.getInstance((IContext)this).clear((IContext)this);
    }

    public void fullReset() {
        super.reset();
    }

    public void setMapping(Mapping mapping) {
        this.mapping = mapping;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public BlockArchitecture getTempBlockArchitecture() {
        return this.mapping.getTempBlockArchitecture(this);
    }

    public SystemEngineering getTempSystemEngineering() {
        return SubSystemContextHelper.getTransformedEngineering((IContext)this);
    }

    public SystemAnalysis getSourceSystemAnalysis() {
        return (SystemAnalysis)this.getSourceSystemEngineering().getContainedSystemAnalysis().get(0);
    }

    public LogicalArchitecture getSourceLogicalArchitecture() {
        return (LogicalArchitecture)this.getSourceSystemEngineering().getContainedLogicalArchitectures().get(0);
    }

    public PhysicalArchitecture getSourcePhysicalArchitecture() {
        return (PhysicalArchitecture)this.getSourceSystemEngineering().getContainedPhysicalArchitectures().get(0);
    }

    public SystemEngineering getSourceSystemEngineering() {
        return ContextHelper.getSourceEngineering((IContext)this);
    }

    public SystemAnalysis getTempSystemAnalysis() {
        return (SystemAnalysis)this.getTempSystemEngineering().getContainedSystemAnalysis().get(0);
    }

    public LogicalArchitecture getTempLogicalArchitecture() {
        return (LogicalArchitecture)this.getTempSystemEngineering().getContainedLogicalArchitectures().get(0);
    }

    public PhysicalArchitecture getTempPhysicalArchitecture() {
        return (PhysicalArchitecture)this.getTempSystemEngineering().getContainedPhysicalArchitectures().get(0);
    }

    public EObject getTempRootComponent() {
        return this.mapping.getTempRootComponent(this);
    }

    public static enum Mapping {
        SA("org.polarsys.capella.transition.system2subsystem.multiphases.sa", CtxPackage.Literals.SYSTEM_ANALYSIS),
        LA("org.polarsys.capella.transition.system2subsystem.multiphases.la", LaPackage.Literals.LOGICAL_ARCHITECTURE),
        PA("org.polarsys.capella.transition.system2subsystem.multiphases.pa", PaPackage.Literals.PHYSICAL_ARCHITECTURE);

        private final String mapping_id;
        private final EClass blockArchitecture;

        private Mapping(String mapping, EClass blockArchitecture) {
            this.mapping_id = mapping;
            this.blockArchitecture = blockArchitecture;
        }

        public String getMappingId() {
            return this.mapping_id;
        }

        public EClass getBlockArchitectureClass() {
            return this.blockArchitecture;
        }

        private BlockArchitecture getTempBlockArchitecture(MultiphasesContext context) {
            SystemEngineering eng = context.getTempSystemEngineering();
            for (ModellingArchitecture ma : eng.getOwnedArchitectures()) {
                if (!this.blockArchitecture.isInstance((Object)ma)) continue;
                return (BlockArchitecture)ma;
            }
            throw new IllegalStateException("No blockarchitecture of type '" + this.blockArchitecture.eClass().getName() + "' in temp system engineering! ");
        }

        private EObject getTempRootComponent(MultiphasesContext context) {
            BlockArchitecture ba = this.getTempBlockArchitecture(context);
            if (ba.getSystem() != null) {
                return ba.getSystem();
            }
            throw new IllegalStateException("No root component for " + this.blockArchitecture.eClass().getName());
        }
    }
}

