/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ui.properties.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.ui.properties.viewers.ICellEditorProvider;
import org.polarsys.capella.core.ui.properties.viewers.TableDelegatedViewer;
import org.polarsys.capella.vp.requirements.model.helpers.RelationAnnotationHelper;
import org.polarsys.capella.vp.requirements.ui.properties.TableDelegatedViewerComparator;
import org.polarsys.capella.vp.requirements.ui.properties.controllers.DiagramIncomingLink;
import org.polarsys.capella.vp.requirements.ui.properties.controllers.DiagramOutgoingLink;
import org.polarsys.capella.vp.requirements.ui.properties.widgets.TableviewUIExtender;
import org.polarsys.kitalpha.vp.requirements.Requirements.AbstractRelation;
import org.polarsys.kitalpha.vp.requirements.Requirements.RelationType;
import org.polarsys.kitalpha.vp.requirements.Requirements.RequirementsPackage;

public class RelationTypeTableDelegatedViewer
extends TableDelegatedViewer {
    private TableDelegatedViewerComparator comparator;
    private TableViewer viewer;
    private TableViewerColumn viewerColumn;

    public RelationTypeTableDelegatedViewer(TabbedPropertySheetWidgetFactory widgetFactory, ICellEditorProvider cellEditorProvider) {
        super(widgetFactory, cellEditorProvider);
    }

    protected TableViewerColumn createTableViewerColumn(int colNumber, ColumnLabelProvider labelProvider) {
        this.initTableViewerColumnCreation();
        if (colNumber == 0) {
            TableColumn column = this.viewerColumn.getColumn();
            column.setText(this.getColumnProperties()[colNumber]);
            column.setWidth(200);
            column.setResizable(true);
            column.setMoveable(false);
            column.addSelectionListener((SelectionListener)this.getSelectionAdapter(column, colNumber));
            this.viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
            return this.viewerColumn;
        }
        if (colNumber == 1) {
            this.viewerColumn.setEditingSupport(new EditingSupport(this.getColumnViewer()){

                protected void setValue(Object element, final Object value) {
                    if (element instanceof AbstractRelation) {
                        final AbstractRelation relation = (AbstractRelation)element;
                        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(RequirementsPackage.eINSTANCE.getAbstractRelation(), (EStructuralFeature)RequirementsPackage.eINSTANCE.getAbstractRelation_RelationType());
                        final List availableElements = query.getAvailableElements((EObject)relation);
                        if (value instanceof Integer && (Integer)value >= 0 && availableElements.get((Integer)value) instanceof RelationType) {
                            AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                                public void run() {
                                    relation.setRelationType((RelationType)availableElements.get((Integer)value));
                                }
                            };
                            if (relation instanceof DiagramOutgoingLink) {
                                TransactionHelper.getExecutionManager((EObject)((DiagramOutgoingLink)relation).getSource()).execute((ICommand)command);
                            } else if (relation instanceof DiagramIncomingLink) {
                                TransactionHelper.getExecutionManager((EObject)((DiagramIncomingLink)relation).getTarget()).execute((ICommand)command);
                            } else {
                                TransactionHelper.getExecutionManager((EObject)relation).execute((ICommand)command);
                            }
                            if (relation instanceof DiagramOutgoingLink) {
                                RelationAnnotationHelper.updateAllocation((DRepresentation)((DiagramOutgoingLink)relation).getContainingRepresentation(), (AbstractRelation)relation, (String)((DiagramOutgoingLink)relation).getId());
                            } else if (relation instanceof DiagramIncomingLink) {
                                RelationAnnotationHelper.updateAllocation((DRepresentation)((DiagramIncomingLink)relation).getContainingRepresentation(), (AbstractRelation)relation, (String)((DiagramIncomingLink)relation).getId());
                            }
                        }
                    }
                    this.getViewer().update(element, null);
                }

                protected Object getValue(Object element) {
                    if (element instanceof AbstractRelation) {
                        AbstractRelation relation = (AbstractRelation)element;
                        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(RequirementsPackage.eINSTANCE.getAbstractRelation(), (EStructuralFeature)RequirementsPackage.eINSTANCE.getAbstractRelation_RelationType());
                        List availableElements = query.getAvailableElements((EObject)relation);
                        if (query.getCurrentElements((EObject)relation, false).size() > 0) {
                            EObject currentElement = (EObject)query.getCurrentElements((EObject)relation, false).get(0);
                            return availableElements.indexOf(currentElement);
                        }
                    }
                    return 0;
                }

                protected CellEditor getCellEditor(Object element) {
                    ArrayList relationTypes = new ArrayList();
                    if (element instanceof AbstractRelation) {
                        AbstractRelation relation = (AbstractRelation)element;
                        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(RequirementsPackage.eINSTANCE.getAbstractRelation(), (EStructuralFeature)RequirementsPackage.eINSTANCE.getAbstractRelation_RelationType());
                        relationTypes.addAll(query.getAvailableElements((EObject)relation));
                    }
                    String[] relationTypeNames = new String[relationTypes.size()];
                    int i = 0;
                    while (i < relationTypes.size()) {
                        if (relationTypes.get(i) instanceof RelationType) {
                            relationTypeNames[i] = ((RelationType)relationTypes.get(i)).getReqIFLongName();
                        }
                        ++i;
                    }
                    ComboBoxCellEditor cellEditor = new ComboBoxCellEditor((Composite)RelationTypeTableDelegatedViewer.this._table, relationTypeNames);
                    CCombo combo = (CCombo)cellEditor.getControl();
                    combo.setEditable(false);
                    return cellEditor;
                }

                protected boolean canEdit(Object element) {
                    return true;
                }
            });
            TableColumn column = this.viewerColumn.getColumn();
            column.setText(this.getColumnProperties()[colNumber]);
            column.setWidth(200);
            column.setResizable(true);
            column.setMoveable(false);
            column.addSelectionListener((SelectionListener)this.getSelectionAdapter(column, colNumber));
            this.viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
            return this.viewerColumn;
        }
        return super.createTableViewerColumn(colNumber, labelProvider);
    }

    public StructuredSelection getSelectedObjectFromSelection(TableItem[] inSelection) {
        if (inSelection != null && inSelection.length > 0) {
            return new StructuredSelection(inSelection[0].getData());
        }
        return null;
    }

    private void initTableViewerColumnCreation() {
        this.viewerColumn = new TableViewerColumn((TableViewer)this.getColumnViewer(), 0);
        this.comparator = new TableDelegatedViewerComparator();
        this.viewer = (TableViewer)this.getColumnViewer();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        if (this._table.getMenu() == null) {
            Menu contextMenu = new Menu((Control)this._table);
            this._table.setMenu(contextMenu);
            new TableviewUIExtender(contextMenu, this._table){

                @Override
                public StructuredSelection getSelectedFromSelection(TableItem[] inSelection) {
                    return RelationTypeTableDelegatedViewer.this.getSelectedObjectFromSelection(inSelection);
                }
            };
        }
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationTypeTableDelegatedViewer.this.comparator.setColumn(index);
                int dir = RelationTypeTableDelegatedViewer.this.comparator.getDirection();
                RelationTypeTableDelegatedViewer.this.viewer.getTable().setSortDirection(dir);
                RelationTypeTableDelegatedViewer.this.viewer.getTable().setSortColumn(column);
                RelationTypeTableDelegatedViewer.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }
}

