/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.transposer.bridge.categories;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.categories.AbstractDifferenceCategory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.ui.services.helper.EObjectImageProviderHelper;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.Messages;

public class EClassCategory
extends AbstractDifferenceCategory {
    Collection<EClass> clazzes;
    EClass iconClazz;
    String name;
    String description;

    public boolean keepElement(Object element) {
        for (EClass clazz : this.clazzes) {
            if (!clazz.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    public EClassCategory(EClass iconClazz, String name, EClass clazz) {
        this(iconClazz, name, Collections.singletonList(clazz));
    }

    public EClassCategory(EClass iconClazz, String name, Collection<EClass> clazzes) {
        this.setInFocusMode(false);
        this.clazzes = clazzes;
        this.iconClazz = iconClazz;
        this.name = NLS.bind((String)Messages.CategoryFormat_Name, (Object)name);
        this.description = NLS.bind((String)Messages.CategoryFormat_Description, (Object)name);
    }

    public EClassCategory(EClass iconClazz, String name, EClass ... clazzes) {
        this(iconClazz, name, Arrays.asList(clazzes));
    }

    public boolean covers(IDifference difference, EMFDiffNode node) {
        if (difference instanceof IElementPresence) {
            EObject source = ((IElementPresence)difference).getElementMatch().get(Role.REFERENCE);
            EObject target = ((IElementPresence)difference).getElementMatch().get(Role.TARGET);
            for (EClass clazz : this.clazzes) {
                if (!clazz.isInstance((Object)source) && !clazz.isInstance((Object)target)) continue;
                return true;
            }
        }
        return false;
    }

    public String getID() {
        String result = "";
        for (EClass clazz : this.clazzes) {
            result = String.valueOf(result) + clazz.getName() + "; ";
        }
        return result;
    }

    public String getDescription(EMFDiffNode node) {
        return this.description;
    }

    public String getText(EMFDiffNode node) {
        return this.name;
    }

    public Image getImage(final EMFDiffNode node) {
        final Image[] image = new Image[1];
        if (this.iconClazz != null && !this.iconClazz.isAbstract()) {
            TransactionalEditingDomain domain = (TransactionalEditingDomain)node.getEditingDomain();
            ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)domain).execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    Resource res = HoldingResourceHelper.getHoldingResource((TransactionalEditingDomain)((TransactionalEditingDomain)node.getEditingDomain()));
                    EObject obj = ((EPackage)EClassCategory.this.iconClazz.eContainer()).getEFactoryInstance().create(EClassCategory.this.iconClazz);
                    res.getContents().add((Object)obj);
                    image[0] = EObjectImageProviderHelper.getImage((EObject)obj);
                }
            });
        }
        return image[0];
    }
}

