/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.vp.requirements.model.helpers;

import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.common.util.URI;
import org.polarsys.capella.vp.requirements.importer.extension.ReqImporterPreferencesUtil;

public class LabelHelper {
    private LabelHelper() {
    }

    public static String unescape(String content) {
        return StringEscapeUtils.unescapeHtml((String)content);
    }

    public static String toOneLine(String content) {
        return content.replace("\r\n", " ").replace("\n", " ").trim();
    }

    public static String transformHTMLToText(String content) {
        return LabelHelper.toOneLine(LabelHelper.transformHTMLToTextWithLineFeed(content));
    }

    public static String transformHTMLToText(String content, String rootTag) {
        String result = LabelHelper.toOneLine(LabelHelper.transformHTMLToTextWithLineFeed(content));
        if (rootTag != null && LabelHelper.keepHtmlTags()) {
            return "<" + rootTag + ">" + result + "</" + rootTag + ">";
        }
        return result;
    }

    public static String transformHTMLToTextWithLineFeed(String content) {
        if (!LabelHelper.keepHtmlTags()) {
            content = content.replaceAll("<xhtml:br/>", " ").replaceAll("<[^>]*>", "").trim();
            content = URI.decode((String)content);
            content = LabelHelper.unescape(content);
        } else {
            content = content.replaceAll("(?!</xhtml)(?!<xhtml)<[^>]*>", "").replace("xhtml:", "");
        }
        return content;
    }

    public static boolean keepHtmlTags() {
        return (Boolean)ReqImporterPreferencesUtil.getValueForPreferenceKey((String)"keepXHTMLTags", Boolean.class);
    }
}

