/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.transposer.activities;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeTrace;
import org.eclipse.emf.diffmerge.bridge.api.incremental.IIncrementalBridgeExecution;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.ui.progress.UIJob;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.transition.common.activities.AbstractActivity;
import org.polarsys.capella.vp.requirements.importer.transposer.activities.ReqIFJobSchedulingRule;
import org.polarsys.capella.vp.requirements.importer.transposer.bridge.RequirementsVPBridge;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class TransposerTransformation
extends AbstractActivity {
    public static String getId() {
        return TransposerTransformation.class.getCanonicalName();
    }

    protected IStatus _run(final ActivityParameters activityParams) {
        UIJob job = new UIJob("Merge of ReqIF elements"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                return TransposerTransformation.this.mergeAndSave(activityParams);
            }
        };
        job.setRule((ISchedulingRule)ReqIFJobSchedulingRule.getInstance());
        job.setPriority(20);
        job.schedule();
        return Status.OK_STATUS;
    }

    protected IStatus mergeAndSave(ActivityParameters activityParams) {
        final IContext context = (IContext)activityParams.getParameter("TransposerContext").getValue();
        final IEditableModelScope targetScope = (IEditableModelScope)context.get((Object)"TARGET_SCOPE");
        BlockArchitecture target = (BlockArchitecture)context.get((Object)"TARGET_ELEMENT");
        TransactionHelper.getExecutionManager((EObject)target).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                RequirementsVPBridge bridge = (RequirementsVPBridge)((Object)context.get((Object)"BRIDGE"));
                Resource traceResource = (Resource)context.get((Object)"TRACE_RESOURCE");
                IIncrementalBridgeExecution execution2 = (IIncrementalBridgeExecution)context.get((Object)"BRIDGE_EXECUTION");
                IStatus result = bridge.mergeInteractively(execution2, (IProgressMonitor)new NullProgressMonitor());
                if (result == Status.CANCEL_STATUS) {
                    throw new OperationCanceledException(result.getMessage());
                }
                TransposerTransformation.this.save(execution2, traceResource, execution2.getTrace(), targetScope);
                TransactionHelper.getExecutionManager((Resource)traceResource).execute((ICommand)new AbstractReadWriteCommand(){

                    public void run() {
                        HoldingResourceHelper.flushHoldingResource((TransactionalEditingDomain)TransactionHelper.getEditingDomain((EObject)((EObject)targetScope.getContents().get(0))));
                    }
                });
            }
        });
        return Status.OK_STATUS;
    }

    private void save(IIncrementalBridgeExecution execution, Resource traceResource, IBridgeTrace trace, IEditableModelScope targetScope) {
        try {
            traceResource.save(new HashMap());
            ((EObject)targetScope.getContents().get(0)).eResource().save(new HashMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void compact(Resource resource) {
        List filtered = EcoreUtil.filterDescendants((Collection)resource.getContents());
        resource.getContents().retainAll((Collection)filtered);
    }

    protected static void setTrace(final Resource traceResource, final IBridgeTrace trace) {
        TransactionHelper.getExecutionManager((Resource)traceResource).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                traceResource.getContents().clear();
                traceResource.getContents().add((Object)((EObject)trace));
            }
        });
    }
}

