/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.diffmerge.defer.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.impl.helpers.AbstractExpensiveOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.diffmerge.defer.EMFDiffMergeDeferPlugin;
import org.polarsys.capella.diffmerge.defer.Messages;
import org.polarsys.capella.diffmerge.defer.diffdeferdata.DeferredComparison;
import org.polarsys.capella.diffmerge.defer.diffdeferdata.DiffdeferdataFactory;
import org.polarsys.capella.diffmerge.defer.helpers.AbstractNonDirtyingRecordingCommand;
import org.polarsys.capella.diffmerge.defer.helpers.TrimmingCopier;

public class DeferComparisonOperation
extends AbstractExpensiveOperation {
    protected final EComparison comparison;
    protected final ResourceSet resourceSet;
    protected final URI changeResourceURI;
    protected final URI targetScopeURI;
    protected final String comparisonMethodFactoryID;
    protected final TrimmingCopier copier;

    public DeferComparisonOperation(EComparison comparison, ResourceSet resourceSet, URI changeResourceURI, URI targetScopeURI, String comparisonMethodFactoryID) {
        this.comparison = comparison;
        this.resourceSet = resourceSet;
        this.changeResourceURI = changeResourceURI;
        this.targetScopeURI = targetScopeURI;
        this.comparisonMethodFactoryID = comparisonMethodFactoryID;
        this.copier = new TrimmingCopier(comparison);
    }

    protected DeferredComparison createDComparison() {
        DeferredComparison dComparison = DiffdeferdataFactory.eINSTANCE.createDeferredComparison();
        URI targetSiriusURI = this.targetScopeURI.trimFileExtension().appendFileExtension("aird");
        String targetSiriusURIText = targetSiriusURI.toString();
        dComparison.setComparisonMethodFactoryID(this.comparisonMethodFactoryID);
        dComparison.setTargetScopeDefinitionURI(targetSiriusURIText);
        TrimmingCopier copier = this.getCopier();
        EComparison trimmedComparison = copier.copy();
        dComparison.setActualComparison(trimmedComparison);
        List originalSourceRoots = this.comparison.getScope(Role.REFERENCE).getRoots();
        EList<EObject> logicalRoots = dComparison.getLogicalSourceRoots();
        EList<EObject> technicalRoots = dComparison.getTechnicalSourceRoots();
        for (EObject originalSourceElement : copier.getOriginalSourceElements()) {
            EObject copySourceElement = (EObject)copier.get(originalSourceElement);
            if (copySourceElement.eContainer() != null) continue;
            if (originalSourceRoots.contains(originalSourceElement)) {
                logicalRoots.add(copySourceElement);
                continue;
            }
            technicalRoots.add(copySourceElement);
        }
        return dComparison;
    }

    protected TrimmingCopier getCopier() {
        return this.copier;
    }

    protected Resource getDComparisonResource() {
        Resource result = this.resourceSet.createResource(this.changeResourceURI);
        return result;
    }

    public String getOperationName() {
        return Messages.DeferChangesOperation_Name;
    }

    protected int getWorkAmount() {
        return this.comparison.getMapping().size();
    }

    public IStatus run() {
        DeferredComparison dComparison = this.createDComparison();
        Resource dComparisonRessource = this.getDComparisonResource();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)dComparisonRessource);
        if (editingDomain != null) {
            return this.executeInReadWriteTransaction(dComparison, dComparisonRessource, editingDomain);
        }
        return this.doRun(dComparison, dComparisonRessource);
    }

    protected IStatus executeInReadWriteTransaction(final DeferredComparison dComparison, final Resource dComparisonRessource, TransactionalEditingDomain editingDomain) {
        TransactionalCommandStack stack = (TransactionalCommandStack)editingDomain.getCommandStack();
        final ArrayList list = new ArrayList();
        stack.execute((Command)new AbstractNonDirtyingRecordingCommand(editingDomain){

            protected void doExecute() {
                list.add(DeferComparisonOperation.this.doRun(dComparison, dComparisonRessource));
            }
        });
        return (IStatus)list.get(0);
    }

    protected IStatus doRun(DeferredComparison dComparison, Resource dComparisonRessource) {
        IStatus result = Status.OK_STATUS;
        EList resourceContents = dComparisonRessource.getContents();
        resourceContents.add(dComparison);
        for (EObject technicalRoot : dComparison.getTechnicalSourceRoots()) {
            resourceContents.add(technicalRoot);
        }
        try {
            try {
                this.resourceSet.getResources().add((Object)dComparisonRessource);
                this.updateRepresentationDescriptors();
                dComparisonRessource.save(null);
            }
            catch (IOException e) {
                e.printStackTrace();
                result = new Status(4, EMFDiffMergeDeferPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e);
                dComparisonRessource.unload();
                this.resourceSet.getResources().remove((Object)dComparisonRessource);
                this.copier.clear();
            }
        }
        finally {
            dComparisonRessource.unload();
            this.resourceSet.getResources().remove((Object)dComparisonRessource);
            this.copier.clear();
        }
        return result;
    }

    protected void updateRepresentationDescriptors() {
        for (DRepresentationDescriptor originalDescriptor : this.copier.getOriginalRepresentationDescriptors()) {
            EObject copyDescriptor = (EObject)this.copier.get(originalDescriptor);
            DRepresentation originalRepresentation = originalDescriptor.getRepresentation();
            EObject copyRepresentation = (EObject)this.copier.get(originalRepresentation);
            if (!(copyDescriptor instanceof DRepresentationDescriptor) || !(copyRepresentation instanceof DRepresentation)) continue;
            ((DRepresentationDescriptor)copyDescriptor).setRepresentation((DRepresentation)copyRepresentation);
        }
    }
}

