/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.ui.properties.fields;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticKindGroup;

public class EnumerationLiterealValueRadioGroup
extends AbstractSemanticKindGroup {
    private List<Button> buttons = new ArrayList<Button>();

    public EnumerationLiterealValueRadioGroup(Composite parent, String label, EnumerationPropertyType type, TabbedPropertySheetWidgetFactory widgetFactory, int numCols) {
        super(parent, widgetFactory, label, numCols);
        if (type != null && !type.getOwnedLiterals().isEmpty()) {
            EList literals = type.getOwnedLiterals();
            for (EnumerationPropertyLiteral literal : literals) {
                Button button = this.createButton((Composite)this._group, literal.getName(), literal, true, 16);
                this.buttons.add(button);
            }
        } else {
            Button button = this.createButton((Composite)this._group, "UNDEFINED", null, false, 16);
            this.buttons.add(button);
        }
    }

    protected Group createGroup(Composite parent, String label, boolean enabled, int numColumns) {
        super.createGroup(parent, label, enabled, numColumns);
        this._group.setLayout((Layout)new GridLayout(numColumns, false));
        GridData gd = new GridData(1808);
        gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        this._group.setLayoutData((Object)gd);
        return this._group;
    }

    public List<Button> getSemanticFields() {
        return this.buttons;
    }

    public Button getDefaultSemanticField() {
        return this.buttons.get(0);
    }

    public void loadData(EObject semanticElement) {
        this.loadData(semanticElement, this.semanticFeature);
    }

    public void loadData(EObject capellaElement, EStructuralFeature feature) {
        Button defaultBtn;
        super.loadData(capellaElement, feature);
        Object value = this.semanticElement.eGet(this.semanticFeature);
        for (Button button : this.getSemanticFields()) {
            if (button == null) continue;
            button.setSelection(value != null ? value.equals(button.getData()) : false);
        }
        if (value == null && (defaultBtn = this.getDefaultSemanticField()) != null) {
            defaultBtn.setSelection(true);
        }
    }
}

