/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.transition;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.SecurityNeeds;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.model.ThreatApplication;
import org.polarsys.capella.cybersecurity.model.ThreatInvolvement;
import org.polarsys.capella.cybersecurity.test.transition.CyberTopDownTransitionTestCase;

public class ThreatTransitionTest
extends CyberTopDownTransitionTestCase {
    Threat threat;
    Threat threat2;
    SecurityNeeds securityNeeds;
    PrimaryAsset enterprisePrimaryAsset;
    PrimaryAsset functionalPrimaryAsset;
    PrimaryAsset informationPrimaryAsset;
    ThreatApplication threatApplicationEPA;
    ThreatApplication threatApplicationFPA;
    ThreatApplication threatApplicationIPA;
    Entity actor;
    ThreatInvolvement threatInvolvement;

    @Override
    protected void init() {
        super.init();
        this.threat = CybersecurityFactory.eINSTANCE.createThreat();
        this.threat2 = CybersecurityFactory.eINSTANCE.createThreat();
        this.actor = OaFactory.eINSTANCE.createEntity();
        this.enterprisePrimaryAsset = CybersecurityFactory.eINSTANCE.createEnterprisePrimaryAsset();
        this.functionalPrimaryAsset = CybersecurityFactory.eINSTANCE.createFunctionalPrimaryAsset();
        this.informationPrimaryAsset = CybersecurityFactory.eINSTANCE.createInformationPrimaryAsset();
        this.threatApplicationEPA = CybersecurityFactory.eINSTANCE.createThreatApplication();
        this.threatApplicationFPA = CybersecurityFactory.eINSTANCE.createThreatApplication();
        this.threatApplicationIPA = CybersecurityFactory.eINSTANCE.createThreatApplication();
        this.threatInvolvement = CybersecurityFactory.eINSTANCE.createThreatInvolvement();
        EnumerationPropertyType threatKindType = CybersecurityQueries.getThreatKindPropertyType((Project)this.project);
        CybersecurityQueries.setThreatKindFromIndex((Threat)this.threat, (int)1, (EnumerationPropertyType)threatKindType);
        this.threat.setLevel(2);
        this.securityNeeds = CybersecurityFactory.eINSTANCE.createSecurityNeeds();
        CybersecurityQueries.setConfidentialityFromIndex((SecurityNeeds)this.securityNeeds, (int)1, (EnumerationPropertyType)CybersecurityQueries.getConfidentialityPropertyType((Project)this.project));
        CybersecurityQueries.setIntegrityFromIndex((SecurityNeeds)this.securityNeeds, (int)1, (EnumerationPropertyType)CybersecurityQueries.getIntegrityPropertyType((Project)this.project));
        CybersecurityQueries.setTraceabilityFromIndex((SecurityNeeds)this.securityNeeds, (int)1, (EnumerationPropertyType)CybersecurityQueries.getTraceabilityPropertyType((Project)this.project));
        CybersecurityQueries.setAvailabilityFromIndex((SecurityNeeds)this.securityNeeds, (int)1, (EnumerationPropertyType)CybersecurityQueries.getAvailabilityPropertyType((Project)this.project));
        this.threat.getOwnedExtensions().add((Object)this.securityNeeds);
        this.oaPkg.getOwnedThreats().add((Object)this.threat);
        this.oaPkg.getOwnedThreats().add((Object)this.threat2);
        this.oaPkg.getOwnedPrimaryAssets().add((Object)this.enterprisePrimaryAsset);
        this.oaPkg.getOwnedPrimaryAssets().add((Object)this.functionalPrimaryAsset);
        this.oaPkg.getOwnedPrimaryAssets().add((Object)this.informationPrimaryAsset);
        ((OperationalAnalysis)this.oaArch).getOwnedEntityPkg().getOwnedEntities().add((Object)this.actor);
        this.threatApplicationEPA.setAsset(this.enterprisePrimaryAsset);
        this.threatApplicationFPA.setAsset(this.functionalPrimaryAsset);
        this.threatApplicationIPA.setAsset(this.informationPrimaryAsset);
        this.threatInvolvement.setComponent((Component)this.actor);
        this.threat.getOwnedThreatApplications().add((Object)this.threatApplicationEPA);
        this.threat.getOwnedThreatApplications().add((Object)this.threatApplicationFPA);
        this.threat.getOwnedThreatApplications().add((Object)this.threatApplicationIPA);
        this.threat.getOwnedThreatInvolvements().add((Object)this.threatInvolvement);
    }

    @Override
    public void doTest() {
        this.performThreatTransition(this.getObjects(new String[]{this.threat.getId()}));
        Threat systemThreat = (Threat)this.mustBeTransitioned(this.threat.getId(), (EObject)this.saPkg);
        ThreatTransitionTest.assertEquals((Object)this.threat.getKind(), (Object)systemThreat.getKind());
        ThreatTransitionTest.assertEquals((int)this.threat.getLevel(), (int)systemThreat.getLevel());
        ThreatTransitionTest.assertFalse((boolean)this.threat.getIncomingTraces().isEmpty());
        SecurityNeeds transitionedSecurityNeeds = (SecurityNeeds)this.mustBeTransitionedDirecltyContainedBy(this.securityNeeds.getId(), (EObject)systemThreat);
        this.checkSecurityNeedsProperlyTransitioned(transitionedSecurityNeeds);
        PrimaryAsset systemEPA = (PrimaryAsset)this.mustBeTransitionedDirecltyContainedBy(this.enterprisePrimaryAsset.getId(), (EObject)this.saPkg);
        PrimaryAsset systemFPA = (PrimaryAsset)this.mustBeTransitionedDirecltyContainedBy(this.functionalPrimaryAsset.getId(), (EObject)this.saPkg);
        PrimaryAsset systemIPA = (PrimaryAsset)this.mustBeTransitionedDirecltyContainedBy(this.informationPrimaryAsset.getId(), (EObject)this.saPkg);
        ThreatApplication systemThreatApplicationEPA = (ThreatApplication)this.mustBeTransitionedDirecltyContainedBy(this.threatApplicationEPA.getId(), (EObject)systemThreat);
        ThreatApplication systemThreatApplicationFPA = (ThreatApplication)this.mustBeTransitionedDirecltyContainedBy(this.threatApplicationFPA.getId(), (EObject)systemThreat);
        ThreatApplication systemThreatApplicationIPA = (ThreatApplication)this.mustBeTransitionedDirecltyContainedBy(this.threatApplicationIPA.getId(), (EObject)systemThreat);
        ThreatInvolvement transitionedThreatInvolvement = (ThreatInvolvement)this.mustBeTransitionedDirecltyContainedBy(this.threatInvolvement.getId(), (EObject)systemThreat);
        Component transitionedActor = (Component)this.mustBeTransitionedDirecltyContainedBy(this.actor.getId(), (EObject)BlockArchitectureExt.getComponentPkg((BlockArchitecture)this.saArch, (boolean)false));
        ThreatTransitionTest.assertTrue((boolean)this.threat2.getIncomingTraces().isEmpty());
        int count = ((CybersecurityPkg)systemThreat.eContainer()).getOwnedThreats().size();
        this.performThreatTransition(this.getObjects(new String[]{this.threat.getId()}));
        ThreatTransitionTest.assertTrue((this.threat.getRealizingThreats().size() == 1 ? 1 : 0) != 0);
        ThreatTransitionTest.assertTrue((((CybersecurityPkg)systemThreat.eContainer()).getOwnedThreats().size() == count ? 1 : 0) != 0);
        this.performThreatTransition(this.getObjects(new String[]{systemThreat.getId()}));
        Threat logicalThreat = (Threat)this.mustBeTransitioned(systemThreat.getId(), (EObject)this.laPkg);
        ThreatTransitionTest.assertEquals((Object)this.threat.getKind(), (Object)logicalThreat.getKind());
        ThreatTransitionTest.assertEquals((int)this.threat.getLevel(), (int)logicalThreat.getLevel());
        transitionedSecurityNeeds = (SecurityNeeds)this.mustBeTransitionedDirecltyContainedBy(transitionedSecurityNeeds.getId(), (EObject)logicalThreat);
        this.checkSecurityNeedsProperlyTransitioned(transitionedSecurityNeeds);
        PrimaryAsset logicalEPA = (PrimaryAsset)this.mustBeTransitionedDirecltyContainedBy(systemEPA.getId(), (EObject)this.laPkg);
        PrimaryAsset logicalFPA = (PrimaryAsset)this.mustBeTransitionedDirecltyContainedBy(systemFPA.getId(), (EObject)this.laPkg);
        PrimaryAsset logicalIPA = (PrimaryAsset)this.mustBeTransitionedDirecltyContainedBy(systemIPA.getId(), (EObject)this.laPkg);
        ThreatApplication logicalThreatApplicationEPA = (ThreatApplication)this.mustBeTransitionedDirecltyContainedBy(systemThreatApplicationEPA.getId(), (EObject)logicalThreat);
        ThreatApplication logicalThreatApplicationFPA = (ThreatApplication)this.mustBeTransitionedDirecltyContainedBy(systemThreatApplicationFPA.getId(), (EObject)logicalThreat);
        ThreatApplication logicalThreatApplicationIPA = (ThreatApplication)this.mustBeTransitionedDirecltyContainedBy(systemThreatApplicationIPA.getId(), (EObject)logicalThreat);
        transitionedThreatInvolvement = (ThreatInvolvement)this.mustBeTransitionedDirecltyContainedBy(transitionedThreatInvolvement.getId(), (EObject)logicalThreat);
        transitionedActor = (Component)this.mustBeTransitionedDirecltyContainedBy(transitionedActor.getId(), (EObject)BlockArchitectureExt.getComponentPkg((BlockArchitecture)this.laArch, (boolean)false));
        this.performThreatTransition(this.getObjects(new String[]{logicalThreat.getId()}));
        Threat physicalThreat = (Threat)this.mustBeTransitioned(logicalThreat.getId(), (EObject)this.paPkg);
        ThreatTransitionTest.assertEquals((Object)this.threat.getKind(), (Object)physicalThreat.getKind());
        ThreatTransitionTest.assertEquals((int)this.threat.getLevel(), (int)physicalThreat.getLevel());
        transitionedSecurityNeeds = (SecurityNeeds)this.mustBeTransitionedDirecltyContainedBy(transitionedSecurityNeeds.getId(), (EObject)physicalThreat);
        this.checkSecurityNeedsProperlyTransitioned(transitionedSecurityNeeds);
        this.mustBeTransitionedDirecltyContainedBy(logicalEPA.getId(), (EObject)this.paPkg);
        this.mustBeTransitionedDirecltyContainedBy(logicalFPA.getId(), (EObject)this.paPkg);
        this.mustBeTransitionedDirecltyContainedBy(logicalIPA.getId(), (EObject)this.paPkg);
        this.mustBeTransitionedDirecltyContainedBy(logicalThreatApplicationEPA.getId(), (EObject)physicalThreat);
        this.mustBeTransitionedDirecltyContainedBy(logicalThreatApplicationFPA.getId(), (EObject)physicalThreat);
        this.mustBeTransitionedDirecltyContainedBy(logicalThreatApplicationIPA.getId(), (EObject)physicalThreat);
        this.mustBeTransitionedDirecltyContainedBy(transitionedThreatInvolvement.getId(), (EObject)physicalThreat);
        this.mustBeTransitionedDirecltyContainedBy(transitionedActor.getId(), (EObject)BlockArchitectureExt.getComponentPkg((BlockArchitecture)this.paArch, (boolean)false));
    }

    private void checkSecurityNeedsProperlyTransitioned(SecurityNeeds transitionedSecurityNeeds) {
        ThreatTransitionTest.assertEquals((Object)this.securityNeeds.getConfidentialityValue(), (Object)transitionedSecurityNeeds.getConfidentialityValue());
        ThreatTransitionTest.assertEquals((Object)this.securityNeeds.getIntegrityValue(), (Object)transitionedSecurityNeeds.getIntegrityValue());
        ThreatTransitionTest.assertEquals((Object)this.securityNeeds.getTraceabilityValue(), (Object)transitionedSecurityNeeds.getTraceabilityValue());
        ThreatTransitionTest.assertEquals((Object)this.securityNeeds.getAvailabilityValue(), (Object)transitionedSecurityNeeds.getAvailabilityValue());
    }
}

