/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.PortAllocation;

public class FunctionPortAllocator {
    private final Collection<? extends FunctionPort> allocations;

    FunctionPortAllocator(Collection<? extends FunctionPort> eia) {
        this.allocations = eia;
    }

    public FunctionPortAllocator on(ComponentPort cp) {
        for (FunctionPort functionPort : this.allocations) {
            if (cp.getAllocatedFunctionPorts().contains((Object)functionPort)) continue;
            PortAllocation pa = InformationFactory.eINSTANCE.createPortAllocation();
            cp.getOwnedPortAllocations().add((Object)pa);
            pa.setSourceElement((TraceableElement)cp);
            pa.setTargetElement((TraceableElement)functionPort);
        }
        return this;
    }

    public static FunctionPortAllocator allocate(FunctionPort f) {
        return FunctionPortAllocator.allocate(Collections.singleton(f));
    }

    public static FunctionPortAllocator allocate(Collection<? extends FunctionPort> functions) {
        return new FunctionPortAllocator(functions);
    }

    public static FunctionPortAllocator allocate(FunctionPort[] functionPorts) {
        return new FunctionPortAllocator(Arrays.asList(functionPorts));
    }
}

