/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.menu.dynamic.util.INamePrefixService;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPackage;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.model.FunctionStorage;
import org.polarsys.capella.cybersecurity.model.FunctionalPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.InformationPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetMember;
import org.polarsys.capella.cybersecurity.model.SecurityNeeds;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.model.ThreatApplication;
import org.polarsys.capella.cybersecurity.model.ThreatInvolvement;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.capella.cybersecurity.sirius.analysis.ExtensibleElementExt;
import org.polarsys.capella.cybersecurity.sirius.analysis.Messages;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class CybersecurityServices {
    private static final String TRUSTED_COMPONENT_DECORATION = "/org.polarsys.capella.cybersecurity.model.edit/icons/full/ovr16/Trusted.png";
    private static final String UNTRUSTED_COMPONENT_DECORATION = "/org.polarsys.capella.cybersecurity.model.edit/icons/full/ovr16/NotTrusted.png";
    private static final String DATASTORAGE_DECORATION = "/org.polarsys.capella.cybersecurity.model.edit/icons/full/ovr16/DataStorage.png";
    private static final String REMANENT_DECORATION = "/org.polarsys.capella.cybersecurity.model.edit/icons/full/ovr16/RemanentData.png";
    private static final String THREATSOURCE_DECORATION = "/org.polarsys.capella.cybersecurity.model.edit/icons/full/ovr16/ThreatSource.png";
    private static final String PRIMARY_ASSET_DECORATION = "/org.polarsys.capella.cybersecurity.model.edit/icons/full/ovr16/PrimaryAsset.png";
    private static final String FLAME_DECORATION = "/org.polarsys.capella.cybersecurity.model.edit/icons/full/ovr16/TrustLimit.png";
    final INamePrefixService prefixService = (INamePrefixService)PlatformUI.getWorkbench().getService(INamePrefixService.class);
    final PrimitiveIterator.OfInt colorRands = new Random().ints(0, 255).iterator();

    public CybersecurityPkg getDefaultCyberSecurityPackage(EObject any, boolean create) {
        BlockArchitecture ba = (BlockArchitecture)EcoreUtil2.getFirstContainer((EObject)any, (EClass)CsPackage.Literals.BLOCK_ARCHITECTURE);
        if (ba != null) {
            for (EObject e : ba.getOwnedExtensions()) {
                if (!(e instanceof CybersecurityPkg)) continue;
                return (CybersecurityPkg)e;
            }
            if (create) {
                CybersecurityPkg pkg = CybersecurityFactory.eINSTANCE.createCybersecurityPkg();
                pkg.setName(Messages.CybersecurityServices_0);
                ba.getOwnedExtensions().add((Object)pkg);
                return pkg;
            }
        }
        return null;
    }

    public Threat createThreat(EObject any) {
        CybersecurityPkg pkg = this.getDefaultCyberSecurityPackage(any, true);
        if (pkg != null) {
            Threat threat = CybersecurityFactory.eINSTANCE.createThreat();
            pkg.getOwnedThreats().add((Object)threat);
            String elementPrefix = this.prefixService.getPrefix((EObject)threat);
            String uniqueName = CapellaServices.getService().getUniqueName((AbstractNamedElement)threat, elementPrefix);
            threat.setName(uniqueName);
            return threat;
        }
        return null;
    }

    public String getThreatLabel(Threat threat) {
        String kind = threat.getThreatKind().getName().replaceAll("_", " ").toUpperCase();
        String defaultLabel = EObjectLabelProviderHelper.getText((Object)threat);
        return String.valueOf(defaultLabel) + "\n(" + kind + ")";
    }

    public String getPrimaryAssetLabel(EObject asset) {
        return EObjectLabelProviderHelper.getText((Object)asset);
    }

    public String getActorLabel(EObject actor) {
        return EObjectLabelProviderHelper.getText((Object)actor);
    }

    public Collection<EObject> getABPrimaryAssetScope(DSemanticDecorator view) {
        EObject object = view.getTarget();
        CybersecurityPkg cspkg = this.getDefaultCyberSecurityPackage(object, false);
        if (cspkg != null) {
            return new ArrayList<EObject>(EObjectExt.getAll((EObject)cspkg, (EClass)CybersecurityPackage.Literals.PRIMARY_ASSET));
        }
        return Collections.emptyList();
    }

    public int getAssetColor1Red(DSemanticDecorator view) {
        EObject e = view.getTarget();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        for (PrimaryAsset asset : this.getRelatedAssets(e)) {
            DDiagramElement element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)asset);
            if (element == null || !(element instanceof DNode)) continue;
            return ((Square)element.getStyle()).getColor().getRed();
        }
        return 0;
    }

    public int getAssetColor1Blue(DSemanticDecorator view) {
        EObject e = view.getTarget();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        for (PrimaryAsset asset : this.getRelatedAssets(e)) {
            DDiagramElement element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)asset);
            if (element == null || !(element instanceof DNode)) continue;
            return ((Square)element.getStyle()).getColor().getBlue();
        }
        return 0;
    }

    public int getAssetColor1Green(DSemanticDecorator view) {
        EObject e = view.getTarget();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        for (PrimaryAsset asset : this.getRelatedAssets(e)) {
            DDiagramElement element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)asset);
            if (element == null || !(element instanceof DNode)) continue;
            return ((Square)element.getStyle()).getColor().getGreen();
        }
        return 0;
    }

    public FunctionalPrimaryAsset createFunctionalPrimaryAsset(EObject any) {
        FunctionalPrimaryAsset asset = (FunctionalPrimaryAsset)this.attachToDefaultCybersecurityPkg(any, (EObject)CybersecurityFactory.eINSTANCE.createFunctionalPrimaryAsset());
        if (asset != null) {
            String elementPrefix = this.prefixService.getPrefix((EObject)asset);
            String uniqueName = CapellaServices.getService().getUniqueName((AbstractNamedElement)asset, elementPrefix);
            asset.setName(uniqueName);
        }
        return asset;
    }

    public InformationPrimaryAsset createInformationPrimaryAsset(EObject any) {
        InformationPrimaryAsset asset = (InformationPrimaryAsset)this.attachToDefaultCybersecurityPkg(any, (EObject)CybersecurityFactory.eINSTANCE.createInformationPrimaryAsset());
        if (asset != null) {
            String elementPrefix = this.prefixService.getPrefix((EObject)asset);
            String uniqueName = CapellaServices.getService().getUniqueName((AbstractNamedElement)asset, elementPrefix);
            asset.setName(uniqueName);
        }
        return asset;
    }

    private EObject attachToDefaultCybersecurityPkg(EObject context, EObject cyberObject) {
        CybersecurityPkg pkg = this.getDefaultCyberSecurityPackage(context, true);
        Command cmd = AddCommand.create((EditingDomain)TransactionUtil.getEditingDomain((EObject)pkg), (Object)pkg, null, Collections.singleton(cyberObject));
        if (cmd.canExecute()) {
            cmd.execute();
            return cyberObject;
        }
        return null;
    }

    public Component createActor(EObject any) {
        return CsServices.getService().createActor((CapellaElement)BlockArchitectureExt.getRootBlockArchitecture((EObject)any));
    }

    public ThreatInvolvement createThreatInvolvement(Threat threat, Component actor) {
        ThreatInvolvement iv = CybersecurityFactory.eINSTANCE.createThreatInvolvement();
        iv.setThreat(threat);
        actor.getOwnedExtensions().add((Object)iv);
        return iv;
    }

    public ThreatApplication createThreatApplication(Threat threat, PrimaryAsset asset) {
        ThreatApplication ap = CybersecurityFactory.eINSTANCE.createThreatApplication();
        ap.setThreat(threat);
        asset.getOwnedThreatApplications().add((Object)ap);
        return ap;
    }

    public String getTrustDecoration(ModelElement element) {
        return TRUSTED_COMPONENT_DECORATION;
    }

    public String getNoTrustDecoration(ModelElement element) {
        return UNTRUSTED_COMPONENT_DECORATION;
    }

    public String getDatastorageDecoration(ModelElement element) {
        return DATASTORAGE_DECORATION;
    }

    public String getRemanentDataDecoration(ModelElement element) {
        return REMANENT_DECORATION;
    }

    public String getThreatSourceDecoration(ModelElement element) {
        return THREATSOURCE_DECORATION;
    }

    public String getPrimaryAssetDecoration(ModelElement element) {
        return PRIMARY_ASSET_DECORATION;
    }

    protected AbstractFunction getRepresentedFunction(ModelElement element) {
        AbstractFunction af = null;
        if (element instanceof AbstractFunction) {
            af = (AbstractFunction)element;
        } else if (element instanceof StateFragment) {
            af = ((StateFragment)element).getRelatedAbstractFunction();
        }
        return af;
    }

    public String getFlameDecoration(EObject object) {
        return FLAME_DECORATION;
    }

    protected FunctionalExchange getRepresentedFunctionalExchange(ModelElement element) {
        AbstractEventOperation invokedOperation;
        FunctionalExchange fe = null;
        if (element instanceof FunctionalExchange) {
            fe = (FunctionalExchange)element;
        } else if (element instanceof SequenceMessage && (invokedOperation = ((SequenceMessage)element).getInvokedOperation()) instanceof FunctionalExchange) {
            fe = (FunctionalExchange)invokedOperation;
        }
        return fe;
    }

    protected ComponentExchange getRepresentedComponentExchange(ModelElement element) {
        AbstractEventOperation invokedOperation;
        ComponentExchange ce = null;
        if (element instanceof ComponentExchange) {
            ce = (ComponentExchange)element;
        } else if (element instanceof SequenceMessage && (invokedOperation = ((SequenceMessage)element).getInvokedOperation()) instanceof ComponentExchange) {
            ce = (ComponentExchange)invokedOperation;
        }
        return ce;
    }

    public boolean hasDatastorageDecoration(ModelElement element) {
        AbstractFunction af = this.getRepresentedFunction(element);
        if (af != null) {
            FunctionStorage storage = this.getFunctionStorage((ExtensibleElement)af);
            return storage != null && storage.isDataStorage();
        }
        return false;
    }

    public boolean hasRemanentDataDecoration(ModelElement element) {
        AbstractFunction af = this.getRepresentedFunction(element);
        if (af != null) {
            FunctionStorage storage = this.getFunctionStorage((ExtensibleElement)af);
            return storage != null && storage.isRemanentData();
        }
        return false;
    }

    protected Component getRepresentedComponent(ModelElement element) {
        AbstractInstance representedInstance;
        Component component = null;
        if (element instanceof Component) {
            component = (Component)element;
        } else if (element instanceof Part) {
            component = (Component)((Part)element).getAbstractType();
        } else if (element instanceof InstanceRole && (representedInstance = ((InstanceRole)element).getRepresentedInstance()) instanceof Part) {
            component = (Component)((Part)representedInstance).getAbstractType();
        }
        return component;
    }

    public boolean hasTrustDecoration(ModelElement element) {
        Component component = this.getRepresentedComponent(element);
        if (component != null) {
            return CybersecurityQueries.isTrusted((Component)component);
        }
        return false;
    }

    public boolean hasNoTrustDecoration(ModelElement element) {
        Component component = this.getRepresentedComponent(element);
        if (component != null) {
            TrustBoundaryStorage storage = CybersecurityQueries.getTrustBoundaryStorage((ExtensibleElement)component);
            return storage != null && !storage.isTrusted() && !storage.isThreatSource();
        }
        return false;
    }

    public boolean hasThreatSourceDecoration(ModelElement element) {
        Component component = this.getRepresentedComponent(element);
        if (component != null) {
            TrustBoundaryStorage storage = CybersecurityQueries.getTrustBoundaryStorage((ExtensibleElement)component);
            return storage != null && storage.isThreatSource();
        }
        return false;
    }

    private FunctionStorage getFunctionStorage(ExtensibleElement element) {
        return ExtensibleElementExt.getExtension(element, FunctionStorage.class);
    }

    private SecurityNeeds getSecurityNeeds(ExtensibleElement element, boolean create) {
        SecurityNeeds sn = ExtensibleElementExt.getExtension(element, SecurityNeeds.class);
        if (sn == null && create) {
            if (!ExtensibleElementExt.canBeExtendedBy((EObject)element, CybersecurityPackage.Literals.SECURITY_NEEDS)) {
                throw new IllegalArgumentException();
            }
            sn = CybersecurityFactory.eINSTANCE.createSecurityNeeds();
            element.getOwnedExtensions().add((Object)sn);
        }
        return sn;
    }

    private SecurityNeeds getSecurityNeeds(ExtensibleElement element) {
        return this.getSecurityNeeds(element, false);
    }

    public Collection<Component> getAllThreatActors(EObject element) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
        return BlockArchitectureExt.getAllComponents((BlockArchitecture)architecture).stream().filter(c -> c.isActor()).collect(Collectors.toList());
    }

    public Collection<PrimaryAsset> getRelatedAssets(EObject element) {
        FunctionStorage fs;
        ArrayList<EObject> semantics = new ArrayList<EObject>();
        if (element instanceof SequenceMessage) {
            element = this.getRepresentedFunctionalExchange((ModelElement)element);
        } else if (element instanceof StateFragment) {
            element = this.getRepresentedFunction((ModelElement)element);
        }
        semantics.add(element);
        if (element instanceof FunctionalExchange) {
            semantics.addAll((Collection<EObject>)((FunctionalExchange)element).getExchangedItems());
        }
        if (element instanceof AbstractFunction && (fs = this.getFunctionStorage((ExtensibleElement)element)) != null) {
            semantics.addAll((Collection<EObject>)fs.getExchangedItems());
        }
        ArrayList<PrimaryAsset> assets = new ArrayList<PrimaryAsset>();
        for (EObject semantic : semantics) {
            for (EObject member : EObjectExt.getReferencers((EObject)semantic, (EReference)CybersecurityPackage.Literals.PRIMARY_ASSET_MEMBER__MEMBER)) {
                PrimaryAsset asset = ((PrimaryAssetMember)member).getAsset();
                assets.add(asset);
            }
        }
        return assets;
    }

    public boolean hasAssetStyleCustomization(EObject element) {
        TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)element);
        if (domain instanceof SemanticEditingDomainFactory.SemanticEditingDomain) {
            FunctionStorage fs;
            if (element instanceof SequenceMessage) {
                element = this.getRepresentedFunctionalExchange((ModelElement)element);
            } else if (element instanceof StateFragment) {
                element = this.getRepresentedFunction((ModelElement)element);
            }
            Collection refs = ((SemanticEditingDomainFactory.SemanticEditingDomain)domain).getCrossReferencer().getInverseReferences(element, CybersecurityPackage.Literals.PRIMARY_ASSET_MEMBER__MEMBER, true);
            if (!refs.isEmpty()) {
                return true;
            }
            if (element instanceof FunctionalExchange) {
                for (ExchangeItem ei : ((FunctionalExchange)element).getExchangedItems()) {
                    if (!this.hasAssetStyleCustomization((EObject)ei)) continue;
                    return true;
                }
            }
            if (element instanceof AbstractFunction && (fs = this.getFunctionStorage((ExtensibleElement)element)) != null) {
                for (ExchangeItem ei : fs.getExchangedItems()) {
                    if (!this.hasAssetStyleCustomization((EObject)ei)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getAssetDecorationBorderSize(DSemanticDecorator view) {
        if (view instanceof AbstractDNode) {
            EObject e = view.getTarget();
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
            for (PrimaryAsset asset : this.getRelatedAssets(e)) {
                DDiagramElement element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)asset);
                if (!(element instanceof DNode)) continue;
                return "5";
            }
            return "1";
        }
        return null;
    }

    public String getAssetDecorationSize(DSemanticDecorator view) {
        if (view instanceof DEdge) {
            EObject e = view.getTarget();
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
            for (PrimaryAsset asset : this.getRelatedAssets(e)) {
                DDiagramElement element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)asset);
                if (element == null || !(element instanceof DNode)) continue;
                return "5";
            }
            return "1";
        }
        return null;
    }

    public boolean hasTrustedColor(Part part) {
        return CybersecurityQueries.isTrusted((ExtensibleElement)part);
    }

    public boolean hasTrustedColor(InstanceRole element) {
        Component component = this.getRepresentedComponent((ModelElement)element);
        if (component != null) {
            return CybersecurityQueries.isTrusted((Component)component);
        }
        return true;
    }

    public boolean hasFlameDecoration(ModelElement element) {
        ComponentExchange representedComponentExchange = this.getRepresentedComponentExchange(element);
        if (representedComponentExchange != null) {
            return CybersecurityQueries.isTrustBoundary((ComponentExchange)representedComponentExchange);
        }
        FunctionalExchange representedFunctionalExchange = this.getRepresentedFunctionalExchange(element);
        if (representedFunctionalExchange != null) {
            return CybersecurityQueries.isTrustBoundary((FunctionalExchange)representedFunctionalExchange);
        }
        return false;
    }

    public int getConfidentiality(ModelElement modelElement) {
        SecurityNeeds needs;
        AbstractFunction representedFunction = this.getRepresentedFunction(modelElement);
        if (representedFunction != null) {
            modelElement = representedFunction;
        }
        if ((needs = this.getSecurityNeeds((ExtensibleElement)modelElement)) != null) {
            return needs.getConfidentiality();
        }
        return 0;
    }

    public int getIntegrity(ModelElement modelElement) {
        SecurityNeeds needs;
        AbstractFunction representedFunction = this.getRepresentedFunction(modelElement);
        if (representedFunction != null) {
            modelElement = representedFunction;
        }
        if ((needs = this.getSecurityNeeds((ExtensibleElement)modelElement)) != null) {
            return needs.getIntegrity();
        }
        return 0;
    }

    public int getAvailability(ModelElement modelElement) {
        SecurityNeeds needs;
        AbstractFunction representedFunction = this.getRepresentedFunction(modelElement);
        if (representedFunction != null) {
            modelElement = representedFunction;
        }
        if ((needs = this.getSecurityNeeds((ExtensibleElement)modelElement)) != null) {
            return needs.getAvailability();
        }
        return 0;
    }

    public int getTraceability(ModelElement modelElement) {
        SecurityNeeds needs;
        AbstractFunction representedFunction = this.getRepresentedFunction(modelElement);
        if (representedFunction != null) {
            modelElement = representedFunction;
        }
        if ((needs = this.getSecurityNeeds((ExtensibleElement)modelElement)) != null) {
            return needs.getTraceability();
        }
        return 0;
    }

    public int getMaxSecurityNeedValue(DSemanticDecorator decorator) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)decorator);
        ModelElement element = (ModelElement)decorator.getTarget();
        Set activatedLayerNames = new DDiagramQuery(diagram).getAllActivatedLayers().stream().map(IdentifiedElement::getName).collect(Collectors.toSet());
        int maxSecurityNeedValue = 0;
        if (activatedLayerNames.contains("Cybersecurity Security Needs Confidentiality")) {
            int confidentiality = this.getConfidentiality(element);
            int n = maxSecurityNeedValue = confidentiality > maxSecurityNeedValue ? confidentiality : maxSecurityNeedValue;
        }
        if (activatedLayerNames.contains("Cybersecurity Security Needs Integrity")) {
            int integrity = this.getIntegrity(element);
            int n = maxSecurityNeedValue = integrity > maxSecurityNeedValue ? integrity : maxSecurityNeedValue;
        }
        if (activatedLayerNames.contains("Cybersecurity Security Needs Availability")) {
            int availability = this.getAvailability(element);
            int n = maxSecurityNeedValue = availability > maxSecurityNeedValue ? availability : maxSecurityNeedValue;
        }
        if (activatedLayerNames.contains("Cybersecurity Security Needs Traceability")) {
            int traceability = this.getTraceability(element);
            maxSecurityNeedValue = traceability > maxSecurityNeedValue ? traceability : maxSecurityNeedValue;
        }
        return maxSecurityNeedValue;
    }

    public EObject setNewRandomColor(DNode assetView) {
        ((Square)assetView.getOwnedStyle()).setColor(RGBValues.create((int)this.colorRands.nextInt(), (int)this.colorRands.nextInt(), (int)this.colorRands.nextInt()));
        ((Square)assetView.getOwnedStyle()).getCustomFeatures().add((Object)"color");
        return assetView;
    }

    public IFigure getThreatLevelDecorator(EObject context, DSemanticDiagram diagram) {
        ThreatLevelDecorator decorator = (ThreatLevelDecorator)EcoreUtil.getExistingAdapter((Notifier)context, ThreatLevelDecorator.class);
        if (decorator != null) {
            return decorator.getLabel();
        }
        decorator = new ThreatLevelDecorator((Threat)context);
        context.eAdapters().add((Object)decorator);
        return decorator.getLabel();
    }

    public boolean hasThreatLevelDecorator(ModelElement context) {
        return context instanceof Threat;
    }

    public void setConfidentiality(ExtensibleElement element, int value) {
        SecurityNeeds sn = this.getSecurityNeeds(element, true);
        sn.setConfidentiality(value);
    }

    public void setIntegrity(ExtensibleElement element, int value) {
        SecurityNeeds sn = this.getSecurityNeeds(element, true);
        sn.setIntegrity(value);
    }

    public void setTraceability(ExtensibleElement element, int value) {
        SecurityNeeds sn = this.getSecurityNeeds(element, true);
        sn.setTraceability(value);
    }

    public void setAvailability(ExtensibleElement element, int value) {
        SecurityNeeds sn = this.getSecurityNeeds(element, true);
        sn.setAvailability(value);
    }

    private static class ThreatLevelDecorator
    extends AdapterImpl {
        private static final String FONT = "CybersecurityServices.ThreatLevelDecoratorFont";
        private final Label label;

        private ThreatLevelDecorator(Threat threat) {
            this.label = new Label(this.getLabelText(threat)){

                public void removeNotify() {
                    this.removeDecorator();
                }

                public void addNotify() {
                }
            };
            this.label.setFont(this.getThreatLevelDecoratorFont());
            Rectangle bounds = this.label.getTextBounds();
            this.label.setBounds(bounds);
        }

        private void removeDecorator() {
            Notifier notifier = this.getTarget();
            if (notifier != null) {
                notifier.eAdapters().remove((Object)this);
            }
        }

        private String getLabelText(Threat threat) {
            return "(" + String.valueOf(threat.getLevel()) + ")";
        }

        private Label getLabel() {
            return this.label;
        }

        public boolean isAdapterForType(Object type) {
            return type == ThreatLevelDecorator.class;
        }

        private void updateLabel(Threat t) {
            this.label.setText(this.getLabelText(t));
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == CybersecurityPackage.Literals.THREAT__LEVEL) {
                this.updateLabel((Threat)msg.getNotifier());
            }
        }

        private Font getThreatLevelDecoratorFont() {
            return JFaceResources.getFontRegistry().defaultFont();
        }
    }
}

