/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.io.File;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.UnknownModelException;
import org.gradle.tooling.internal.adapter.ObjectGraphAdapter;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.ViewBuilder;
import org.gradle.tooling.internal.consumer.connection.AbstractBuildController;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalBuildController;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.internal.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BuildControllerAdapter
extends AbstractBuildController
implements BuildController {
    private final InternalBuildController buildController;
    private final ProtocolToModelAdapter adapter;
    private final ObjectGraphAdapter resultAdapter;
    private final ModelMapping modelMapping;
    private final File rootDir;

    public BuildControllerAdapter(ProtocolToModelAdapter adapter, InternalBuildController buildController, ModelMapping modelMapping, File rootDir) {
        this.adapter = adapter;
        this.buildController = buildController;
        this.modelMapping = modelMapping;
        this.rootDir = rootDir;
        this.resultAdapter = adapter.newGraph();
    }

    @Override
    public <T> T getModel(Model target, Class<T> modelType) throws UnknownModelException {
        BuildResult<?> result;
        ModelIdentifier modelIdentifier = this.modelMapping.getModelIdentifierFromModelType(modelType);
        Object originalTarget = target == null ? null : this.adapter.unpack(target);
        try {
            result = this.buildController.getModel(originalTarget, modelIdentifier);
        }
        catch (InternalUnsupportedModelException e) {
            throw Exceptions.unknownModel(modelType, e);
        }
        ViewBuilder<T> viewBuilder = this.resultAdapter.builder(modelType);
        this.applyCompatibilityMapping(viewBuilder, new DefaultProjectIdentifier(this.rootDir, this.getProjectPath(target)));
        return viewBuilder.build(result.getModel());
    }

    private String getProjectPath(Model target) {
        if (target instanceof ProjectModel) {
            return ((ProjectModel)((Object)target)).getProjectIdentifier().getProjectPath();
        }
        return ":";
    }
}

