/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ExecutorPolicy;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.internal.concurrent.StoppableExecutorImpl;
import org.gradle.internal.concurrent.StoppableScheduledExecutor;
import org.gradle.internal.concurrent.StoppableScheduledExecutorImpl;
import org.gradle.internal.concurrent.ThreadFactoryImpl;

public class DefaultExecutorFactory
implements ExecutorFactory,
Stoppable {
    private final Set<StoppableExecutor> executors = new CopyOnWriteArraySet<StoppableExecutor>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            CompositeStoppable.stoppable(this.executors).stop();
        }
        finally {
            this.executors.clear();
        }
    }

    public StoppableExecutor create(String displayName) {
        TrackedStoppableExecutor executor = new TrackedStoppableExecutor(this.createExecutor(displayName), new ExecutorPolicy.CatchAndRecordFailures());
        this.executors.add(executor);
        return executor;
    }

    protected ExecutorService createExecutor(String displayName) {
        return Executors.newCachedThreadPool(new ThreadFactoryImpl(displayName));
    }

    public StoppableExecutor create(String displayName, int fixedSize) {
        TrackedStoppableExecutor executor = new TrackedStoppableExecutor(this.createExecutor(displayName, fixedSize), new ExecutorPolicy.CatchAndRecordFailures());
        this.executors.add(executor);
        return executor;
    }

    protected ExecutorService createExecutor(String displayName, int fixedSize) {
        return Executors.newFixedThreadPool(fixedSize, new ThreadFactoryImpl(displayName));
    }

    public StoppableScheduledExecutor createScheduled(String displayName, int fixedSize) {
        ScheduledExecutorService delegate = this.createScheduledExecutor(displayName, fixedSize);
        TrackedScheduledStoppableExecutor executor = new TrackedScheduledStoppableExecutor(delegate, new ExecutorPolicy.CatchAndRecordFailures());
        this.executors.add(executor);
        return executor;
    }

    private ScheduledExecutorService createScheduledExecutor(String displayName, int fixedSize) {
        return new ScheduledThreadPoolExecutor(fixedSize, new ThreadFactoryImpl(displayName));
    }

    private class TrackedScheduledStoppableExecutor
    extends StoppableScheduledExecutorImpl {
        public TrackedScheduledStoppableExecutor(ScheduledExecutorService executor, ExecutorPolicy executorPolicy) {
            super(executor, executorPolicy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(int timeoutValue, TimeUnit timeoutUnits) throws IllegalStateException {
            try {
                super.stop(timeoutValue, timeoutUnits);
            }
            finally {
                DefaultExecutorFactory.this.executors.remove(this);
            }
        }
    }

    private class TrackedStoppableExecutor
    extends StoppableExecutorImpl {
        public TrackedStoppableExecutor(ExecutorService executor, ExecutorPolicy executorPolicy) {
            super(executor, executorPolicy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(int timeoutValue, TimeUnit timeoutUnits) throws IllegalStateException {
            try {
                super.stop(timeoutValue, timeoutUnits);
            }
            finally {
                DefaultExecutorFactory.this.executors.remove(this);
            }
        }
    }
}

